/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportTaskResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, CreateImportTaskResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(CreateImportTaskResponse.getter(CreateImportTaskResponse::importId)).setter(CreateImportTaskResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<String> IMPORT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importDestinationArn").getter(CreateImportTaskResponse.getter(CreateImportTaskResponse::importDestinationArn)).setter(CreateImportTaskResponse.setter(Builder::importDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDestinationArn").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(CreateImportTaskResponse.getter(CreateImportTaskResponse::creationTime)).setter(CreateImportTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_DESTINATION_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImportTaskResponse.memberNameToFieldInitializer();
    private final String importId;
    private final String importDestinationArn;
    private final Long creationTime;

    private CreateImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importDestinationArn = builder.importDestinationArn;
        this.creationTime = builder.creationTime;
    }

    public final String importId() {
        return this.importId;
    }

    public final String importDestinationArn() {
        return this.importDestinationArn;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportTaskResponse)) {
            return false;
        }
        CreateImportTaskResponse other = (CreateImportTaskResponse)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importDestinationArn(), other.importDestinationArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImportTaskResponse").add("ImportId", (Object)this.importId()).add("ImportDestinationArn", (Object)this.importDestinationArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.importDestinationArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("importDestinationArn", IMPORT_DESTINATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImportTaskResponse, T> g) {
        return obj -> g.apply((CreateImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String importId;
        private String importDestinationArn;
        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportTaskResponse model) {
            super(model);
            this.importId(model.importId);
            this.importDestinationArn(model.importDestinationArn);
            this.creationTime(model.creationTime);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportDestinationArn() {
            return this.importDestinationArn;
        }

        public final void setImportDestinationArn(String importDestinationArn) {
            this.importDestinationArn = importDestinationArn;
        }

        @Override
        public final Builder importDestinationArn(String importDestinationArn) {
            this.importDestinationArn = importDestinationArn;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateImportTaskResponse build() {
            return new CreateImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImportTaskResponse> {
        public Builder importId(String var1);

        public Builder importDestinationArn(String var1);

        public Builder creationTime(Long var1);
    }
}

