/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.S3TableIntegrationSource;

public class ListSourcesForS3TableIntegrationIterable
implements SdkIterable<ListSourcesForS3TableIntegrationResponse> {
    private final CloudWatchLogsClient client;
    private final ListSourcesForS3TableIntegrationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourcesForS3TableIntegrationIterable(CloudWatchLogsClient client, ListSourcesForS3TableIntegrationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSourcesForS3TableIntegrationResponseFetcher();
    }

    public Iterator<ListSourcesForS3TableIntegrationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<S3TableIntegrationSource> sources() {
        Function<ListSourcesForS3TableIntegrationResponse, Iterator> getIterator = response -> {
            if (response != null && response.sources() != null) {
                return response.sources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourcesForS3TableIntegrationResponseFetcher
    implements SyncPageFetcher<ListSourcesForS3TableIntegrationResponse> {
        private ListSourcesForS3TableIntegrationResponseFetcher() {
        }

        public boolean hasNextPage(ListSourcesForS3TableIntegrationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourcesForS3TableIntegrationResponse nextPage(ListSourcesForS3TableIntegrationResponse previousPage) {
            if (previousPage == null) {
                return ListSourcesForS3TableIntegrationIterable.this.client.listSourcesForS3TableIntegration(ListSourcesForS3TableIntegrationIterable.this.firstRequest);
            }
            return ListSourcesForS3TableIntegrationIterable.this.client.listSourcesForS3TableIntegration((ListSourcesForS3TableIntegrationRequest)((Object)ListSourcesForS3TableIntegrationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

