/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilter;

public class DescribeMetricFiltersIterable
implements SdkIterable<DescribeMetricFiltersResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeMetricFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetricFiltersIterable(CloudWatchLogsClient client, DescribeMetricFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetricFiltersResponseFetcher();
    }

    public Iterator<DescribeMetricFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricFilter> metricFilters() {
        Function<DescribeMetricFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricFilters() != null) {
                return response.metricFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMetricFiltersResponseFetcher
    implements SyncPageFetcher<DescribeMetricFiltersResponse> {
        private DescribeMetricFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetricFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMetricFiltersResponse nextPage(DescribeMetricFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetricFiltersIterable.this.client.describeMetricFilters(DescribeMetricFiltersIterable.this.firstRequest);
            }
            return DescribeMetricFiltersIterable.this.client.describeMetricFilters((DescribeMetricFiltersRequest)((Object)DescribeMetricFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

