/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a subscription filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscriptionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscriptionFilter.Builder, SubscriptionFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(SubscriptionFilter::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(SubscriptionFilter::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(SubscriptionFilter::filterPattern)).setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(SubscriptionFilter::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(SubscriptionFilter::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distribution").getter(getter(SubscriptionFilter::distributionAsString))
            .setter(setter(Builder::distribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()).build();

    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyOnTransformedLogs").getter(getter(SubscriptionFilter::applyOnTransformedLogs))
            .setter(setter(Builder::applyOnTransformedLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOnTransformedLogs").build())
            .build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(SubscriptionFilter::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> FIELD_SELECTION_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldSelectionCriteria").getter(getter(SubscriptionFilter::fieldSelectionCriteria))
            .setter(setter(Builder::fieldSelectionCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSelectionCriteria").build())
            .build();

    private static final SdkField<List<String>> EMIT_SYSTEM_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("emitSystemFields")
            .getter(getter(SubscriptionFilter::emitSystemFields))
            .setter(setter(Builder::emitSystemFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emitSystemFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD,
            LOG_GROUP_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD,
            APPLY_ON_TRANSFORMED_LOGS_FIELD, CREATION_TIME_FIELD, FIELD_SELECTION_CRITERIA_FIELD, EMIT_SYSTEM_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterName;

    private final String logGroupName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private final Boolean applyOnTransformedLogs;

    private final Long creationTime;

    private final String fieldSelectionCriteria;

    private final List<String> emitSystemFields;

    private SubscriptionFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.logGroupName = builder.logGroupName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
        this.creationTime = builder.creationTime;
        this.fieldSelectionCriteria = builder.fieldSelectionCriteria;
        this.emitSystemFields = builder.emitSystemFields;
    }

    /**
     * <p>
     * The name of the subscription filter.
     * </p>
     * 
     * @return The name of the subscription filter.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * Returns the value of the FilterPattern property for this object.
     * 
     * @return The value of the FilterPattern property for this object.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the Distribution property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The value of the Distribution property for this object.
     * @see Distribution
     */
    public final Distribution distribution() {
        return Distribution.fromValue(distribution);
    }

    /**
     * Returns the value of the Distribution property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The value of the Distribution property for this object.
     * @see Distribution
     */
    public final String distributionAsString() {
        return distribution;
    }

    /**
     * <p>
     * This parameter is valid only for log groups that have an active log transformer. For more information about log
     * transformers, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>.
     * </p>
     * <p>
     * If this value is <code>true</code>, the subscription filter is applied on the transformed version of the log
     * events instead of the original ingested log events.
     * </p>
     * 
     * @return This parameter is valid only for log groups that have an active log transformer. For more information
     *         about log transformers, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     *         >PutTransformer</a>.</p>
     *         <p>
     *         If this value is <code>true</code>, the subscription filter is applied on the transformed version of the
     *         log events instead of the original ingested log events.
     */
    public final Boolean applyOnTransformedLogs() {
        return applyOnTransformedLogs;
    }

    /**
     * <p>
     * The creation time of the subscription filter, expressed as the number of milliseconds after
     * <code>Jan 1, 1970 00:00:00 UTC</code>.
     * </p>
     * 
     * @return The creation time of the subscription filter, expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The filter expression that specifies which log events are processed by this subscription filter based on system
     * fields. Returns the <code>fieldSelectionCriteria</code> value if it was specified when the subscription filter
     * was created.
     * </p>
     * 
     * @return The filter expression that specifies which log events are processed by this subscription filter based on
     *         system fields. Returns the <code>fieldSelectionCriteria</code> value if it was specified when the
     *         subscription filter was created.
     */
    public final String fieldSelectionCriteria() {
        return fieldSelectionCriteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmitSystemFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmitSystemFields() {
        return emitSystemFields != null && !(emitSystemFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of system fields that are included in the log events sent to the subscription destination. Returns the
     * <code>emitSystemFields</code> value if it was specified when the subscription filter was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmitSystemFields} method.
     * </p>
     * 
     * @return The list of system fields that are included in the log events sent to the subscription destination.
     *         Returns the <code>emitSystemFields</code> value if it was specified when the subscription filter was
     *         created.
     */
    public final List<String> emitSystemFields() {
        return emitSystemFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyOnTransformedLogs());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fieldSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmitSystemFields() ? emitSystemFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionFilter)) {
            return false;
        }
        SubscriptionFilter other = (SubscriptionFilter) obj;
        return Objects.equals(filterName(), other.filterName()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(distributionAsString(), other.distributionAsString())
                && Objects.equals(applyOnTransformedLogs(), other.applyOnTransformedLogs())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(fieldSelectionCriteria(), other.fieldSelectionCriteria())
                && hasEmitSystemFields() == other.hasEmitSystemFields()
                && Objects.equals(emitSystemFields(), other.emitSystemFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscriptionFilter").add("FilterName", filterName()).add("LogGroupName", logGroupName())
                .add("FilterPattern", filterPattern()).add("DestinationArn", destinationArn()).add("RoleArn", roleArn())
                .add("Distribution", distributionAsString()).add("ApplyOnTransformedLogs", applyOnTransformedLogs())
                .add("CreationTime", creationTime()).add("FieldSelectionCriteria", fieldSelectionCriteria())
                .add("EmitSystemFields", hasEmitSystemFields() ? emitSystemFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "distribution":
            return Optional.ofNullable(clazz.cast(distributionAsString()));
        case "applyOnTransformedLogs":
            return Optional.ofNullable(clazz.cast(applyOnTransformedLogs()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "fieldSelectionCriteria":
            return Optional.ofNullable(clazz.cast(fieldSelectionCriteria()));
        case "emitSystemFields":
            return Optional.ofNullable(clazz.cast(emitSystemFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("distribution", DISTRIBUTION_FIELD);
        map.put("applyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("fieldSelectionCriteria", FIELD_SELECTION_CRITERIA_FIELD);
        map.put("emitSystemFields", EMIT_SYSTEM_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionFilter, T> g) {
        return obj -> g.apply((SubscriptionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscriptionFilter> {
        /**
         * <p>
         * The name of the subscription filter.
         * </p>
         * 
         * @param filterName
         *        The name of the subscription filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * Sets the value of the FilterPattern property for this object.
         *
         * @param filterPattern
         *        The new value for the FilterPattern property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p/>
         * 
         * @param roleArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the Distribution property for this object.
         *
         * @param distribution
         *        The new value for the Distribution property for this object.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * Sets the value of the Distribution property for this object.
         *
         * @param distribution
         *        The new value for the Distribution property for this object.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * This parameter is valid only for log groups that have an active log transformer. For more information about
         * log transformers, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         * >PutTransformer</a>.
         * </p>
         * <p>
         * If this value is <code>true</code>, the subscription filter is applied on the transformed version of the log
         * events instead of the original ingested log events.
         * </p>
         * 
         * @param applyOnTransformedLogs
         *        This parameter is valid only for log groups that have an active log transformer. For more information
         *        about log transformers, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
         *        >PutTransformer</a>.</p>
         *        <p>
         *        If this value is <code>true</code>, the subscription filter is applied on the transformed version of
         *        the log events instead of the original ingested log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs);

        /**
         * <p>
         * The creation time of the subscription filter, expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the subscription filter, expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The filter expression that specifies which log events are processed by this subscription filter based on
         * system fields. Returns the <code>fieldSelectionCriteria</code> value if it was specified when the
         * subscription filter was created.
         * </p>
         * 
         * @param fieldSelectionCriteria
         *        The filter expression that specifies which log events are processed by this subscription filter based
         *        on system fields. Returns the <code>fieldSelectionCriteria</code> value if it was specified when the
         *        subscription filter was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSelectionCriteria(String fieldSelectionCriteria);

        /**
         * <p>
         * The list of system fields that are included in the log events sent to the subscription destination. Returns
         * the <code>emitSystemFields</code> value if it was specified when the subscription filter was created.
         * </p>
         * 
         * @param emitSystemFields
         *        The list of system fields that are included in the log events sent to the subscription destination.
         *        Returns the <code>emitSystemFields</code> value if it was specified when the subscription filter was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitSystemFields(Collection<String> emitSystemFields);

        /**
         * <p>
         * The list of system fields that are included in the log events sent to the subscription destination. Returns
         * the <code>emitSystemFields</code> value if it was specified when the subscription filter was created.
         * </p>
         * 
         * @param emitSystemFields
         *        The list of system fields that are included in the log events sent to the subscription destination.
         *        Returns the <code>emitSystemFields</code> value if it was specified when the subscription filter was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitSystemFields(String... emitSystemFields);
    }

    static final class BuilderImpl implements Builder {
        private String filterName;

        private String logGroupName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private Boolean applyOnTransformedLogs;

        private Long creationTime;

        private String fieldSelectionCriteria;

        private List<String> emitSystemFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionFilter model) {
            filterName(model.filterName);
            logGroupName(model.logGroupName);
            filterPattern(model.filterPattern);
            destinationArn(model.destinationArn);
            roleArn(model.roleArn);
            distribution(model.distribution);
            applyOnTransformedLogs(model.applyOnTransformedLogs);
            creationTime(model.creationTime);
            fieldSelectionCriteria(model.fieldSelectionCriteria);
            emitSystemFields(model.emitSystemFields);
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDistribution() {
            return distribution;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution == null ? null : distribution.toString());
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFieldSelectionCriteria() {
            return fieldSelectionCriteria;
        }

        public final void setFieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
        }

        @Override
        public final Builder fieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
            return this;
        }

        public final Collection<String> getEmitSystemFields() {
            if (emitSystemFields instanceof SdkAutoConstructList) {
                return null;
            }
            return emitSystemFields;
        }

        public final void setEmitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
        }

        @Override
        public final Builder emitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emitSystemFields(String... emitSystemFields) {
            emitSystemFields(Arrays.asList(emitSystemFields));
            return this;
        }

        @Override
        public SubscriptionFilter build() {
            return new SubscriptionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
