/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the OpenSearch Service application used for this integration. An OpenSearch
 * Service application is the web application created by the integration with CloudWatch Logs. It hosts the vended logs
 * dashboards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchApplication.Builder, OpenSearchApplication> {
    private static final SdkField<String> APPLICATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationEndpoint").getter(getter(OpenSearchApplication::applicationEndpoint))
            .setter(setter(Builder::applicationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationEndpoint").build())
            .build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(OpenSearchApplication::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(OpenSearchApplication::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<OpenSearchResourceStatus> STATUS_FIELD = SdkField
            .<OpenSearchResourceStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(OpenSearchApplication::status)).setter(setter(Builder::status))
            .constructor(OpenSearchResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ENDPOINT_FIELD,
            APPLICATION_ARN_FIELD, APPLICATION_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationEndpoint;

    private final String applicationArn;

    private final String applicationId;

    private final OpenSearchResourceStatus status;

    private OpenSearchApplication(BuilderImpl builder) {
        this.applicationEndpoint = builder.applicationEndpoint;
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The endpoint of the application.
     * </p>
     * 
     * @return The endpoint of the application.
     */
    public final String applicationEndpoint() {
        return applicationEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * This structure contains information about the status of this OpenSearch Service resource.
     * </p>
     * 
     * @return This structure contains information about the status of this OpenSearch Service resource.
     */
    public final OpenSearchResourceStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchApplication)) {
            return false;
        }
        OpenSearchApplication other = (OpenSearchApplication) obj;
        return Objects.equals(applicationEndpoint(), other.applicationEndpoint())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchApplication").add("ApplicationEndpoint", applicationEndpoint())
                .add("ApplicationArn", applicationArn()).add("ApplicationId", applicationId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationEndpoint":
            return Optional.ofNullable(clazz.cast(applicationEndpoint()));
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationEndpoint", APPLICATION_ENDPOINT_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchApplication, T> g) {
        return obj -> g.apply((OpenSearchApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchApplication> {
        /**
         * <p>
         * The endpoint of the application.
         * </p>
         * 
         * @param applicationEndpoint
         *        The endpoint of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationEndpoint(String applicationEndpoint);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * This structure contains information about the status of this OpenSearch Service resource.
         * </p>
         * 
         * @param status
         *        This structure contains information about the status of this OpenSearch Service resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OpenSearchResourceStatus status);

        /**
         * <p>
         * This structure contains information about the status of this OpenSearch Service resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchResourceStatus.Builder}
         * avoiding the need to create one manually via {@link OpenSearchResourceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchResourceStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(OpenSearchResourceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OpenSearchResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OpenSearchResourceStatus)
         */
        default Builder status(Consumer<OpenSearchResourceStatus.Builder> status) {
            return status(OpenSearchResourceStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationEndpoint;

        private String applicationArn;

        private String applicationId;

        private OpenSearchResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchApplication model) {
            applicationEndpoint(model.applicationEndpoint);
            applicationArn(model.applicationArn);
            applicationId(model.applicationId);
            status(model.status);
        }

        public final String getApplicationEndpoint() {
            return applicationEndpoint;
        }

        public final void setApplicationEndpoint(String applicationEndpoint) {
            this.applicationEndpoint = applicationEndpoint;
        }

        @Override
        public final Builder applicationEndpoint(String applicationEndpoint) {
            this.applicationEndpoint = applicationEndpoint;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final OpenSearchResourceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(OpenSearchResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OpenSearchResourceStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public OpenSearchApplication build() {
            return new OpenSearchApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
