/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGetLogObjectVisitorBuilder implements GetLogObjectResponseHandler.Visitor.Builder {
    private Consumer<GetLogObjectResponseStream> onDefault;

    private Consumer<FieldsData> onFields;

    @Override
    public GetLogObjectResponseHandler.Visitor.Builder onDefault(Consumer<GetLogObjectResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public GetLogObjectResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public GetLogObjectResponseHandler.Visitor.Builder onFields(Consumer<FieldsData> c) {
        this.onFields = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements GetLogObjectResponseHandler.Visitor {
        private final Consumer<GetLogObjectResponseStream> onDefault;

        private final Consumer<FieldsData> onFields;

        VisitorFromBuilder(DefaultGetLogObjectVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : GetLogObjectResponseHandler.Visitor.super::visitDefault;
            this.onFields = builder.onFields != null ? builder.onFields : GetLogObjectResponseHandler.Visitor.super::visitFields;
        }

        @Override
        public void visitDefault(GetLogObjectResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitFields(FieldsData event) {
            onFields.accept(event);
        }
    }
}
