/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.Delivery;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse;

public class DescribeDeliveriesIterable
implements SdkIterable<DescribeDeliveriesResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeDeliveriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDeliveriesIterable(CloudWatchLogsClient client, DescribeDeliveriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDeliveriesResponseFetcher();
    }

    public Iterator<DescribeDeliveriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Delivery> deliveries() {
        Function<DescribeDeliveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deliveries() != null) {
                return response.deliveries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDeliveriesResponseFetcher
    implements SyncPageFetcher<DescribeDeliveriesResponse> {
        private DescribeDeliveriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDeliveriesResponse nextPage(DescribeDeliveriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliveriesIterable.this.client.describeDeliveries(DescribeDeliveriesIterable.this.firstRequest);
            }
            return DescribeDeliveriesIterable.this.client.describeDeliveries((DescribeDeliveriesRequest)((Object)DescribeDeliveriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

