/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.EventSource;
import software.amazon.awssdk.services.cloudwatchlogs.model.OCSFVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParseToOCSF
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParseToOCSF> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ParseToOCSF.getter(ParseToOCSF::source)).setter(ParseToOCSF.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventSource").getter(ParseToOCSF.getter(ParseToOCSF::eventSourceAsString)).setter(ParseToOCSF.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSource").build()}).build();
    private static final SdkField<String> OCSF_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocsfVersion").getter(ParseToOCSF.getter(ParseToOCSF::ocsfVersionAsString)).setter(ParseToOCSF.setter(Builder::ocsfVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocsfVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, EVENT_SOURCE_FIELD, OCSF_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParseToOCSF.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String eventSource;
    private final String ocsfVersion;

    private ParseToOCSF(BuilderImpl builder) {
        this.source = builder.source;
        this.eventSource = builder.eventSource;
        this.ocsfVersion = builder.ocsfVersion;
    }

    public final String source() {
        return this.source;
    }

    public final EventSource eventSource() {
        return EventSource.fromValue(this.eventSource);
    }

    public final String eventSourceAsString() {
        return this.eventSource;
    }

    public final OCSFVersion ocsfVersion() {
        return OCSFVersion.fromValue(this.ocsfVersion);
    }

    public final String ocsfVersionAsString() {
        return this.ocsfVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocsfVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParseToOCSF)) {
            return false;
        }
        ParseToOCSF other = (ParseToOCSF)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.eventSourceAsString(), other.eventSourceAsString()) && Objects.equals(this.ocsfVersionAsString(), other.ocsfVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParseToOCSF").add("Source", (Object)this.source()).add("EventSource", (Object)this.eventSourceAsString()).add("OcsfVersion", (Object)this.ocsfVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "eventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSourceAsString()));
            }
            case "ocsfVersion": {
                return Optional.ofNullable(clazz.cast(this.ocsfVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("source", SOURCE_FIELD);
        map.put("eventSource", EVENT_SOURCE_FIELD);
        map.put("ocsfVersion", OCSF_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParseToOCSF, T> g) {
        return obj -> g.apply((ParseToOCSF)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String eventSource;
        private String ocsfVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ParseToOCSF model) {
            this.source(model.source);
            this.eventSource(model.eventSource);
            this.ocsfVersion(model.ocsfVersion);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final String getOcsfVersion() {
            return this.ocsfVersion;
        }

        public final void setOcsfVersion(String ocsfVersion) {
            this.ocsfVersion = ocsfVersion;
        }

        @Override
        public final Builder ocsfVersion(String ocsfVersion) {
            this.ocsfVersion = ocsfVersion;
            return this;
        }

        @Override
        public final Builder ocsfVersion(OCSFVersion ocsfVersion) {
            this.ocsfVersion(ocsfVersion == null ? null : ocsfVersion.toString());
            return this;
        }

        public ParseToOCSF build() {
            return new ParseToOCSF(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParseToOCSF> {
        public Builder source(String var1);

        public Builder eventSource(String var1);

        public Builder eventSource(EventSource var1);

        public Builder ocsfVersion(String var1);

        public Builder ocsfVersion(OCSFVersion var1);
    }
}

