/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(Destination.getter(Destination::destinationName)).setter(Destination.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(Destination.getter(Destination::targetArn)).setter(Destination.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Destination.getter(Destination::roleArn)).setter(Destination.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPolicy").getter(Destination.getter(Destination::accessPolicy)).setter(Destination.setter(Builder::accessPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Destination.getter(Destination::arn)).setter(Destination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(Destination.getter(Destination::creationTime)).setter(Destination.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, TARGET_ARN_FIELD, ROLE_ARN_FIELD, ACCESS_POLICY_FIELD, ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationName;
    private final String targetArn;
    private final String roleArn;
    private final String accessPolicy;
    private final String arn;
    private final Long creationTime;

    private Destination(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.accessPolicy = builder.accessPolicy;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String accessPolicy() {
        return this.accessPolicy;
    }

    public final String arn() {
        return this.arn;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.accessPolicy(), other.accessPolicy()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("DestinationName", (Object)this.destinationName()).add("TargetArn", (Object)this.targetArn()).add("RoleArn", (Object)this.roleArn()).add("AccessPolicy", (Object)this.accessPolicy()).add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "accessPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPolicy()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("accessPolicy", ACCESS_POLICY_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationName;
        private String targetArn;
        private String roleArn;
        private String accessPolicy;
        private String arn;
        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.destinationName(model.destinationName);
            this.targetArn(model.targetArn);
            this.roleArn(model.roleArn);
            this.accessPolicy(model.accessPolicy);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getAccessPolicy() {
            return this.accessPolicy;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder destinationName(String var1);

        public Builder targetArn(String var1);

        public Builder roleArn(String var1);

        public Builder accessPolicy(String var1);

        public Builder arn(String var1);

        public Builder creationTime(Long var1);
    }
}

