/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationName").getter(PutIntegrationResponse.getter(PutIntegrationResponse::integrationName)).setter(PutIntegrationResponse.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()}).build();
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationStatus").getter(PutIntegrationResponse.getter(PutIntegrationResponse::integrationStatusAsString)).setter(PutIntegrationResponse.setter(Builder::integrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD, INTEGRATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutIntegrationResponse.memberNameToFieldInitializer();
    private final String integrationName;
    private final String integrationStatus;

    private PutIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.integrationStatus = builder.integrationStatus;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(this.integrationStatus);
    }

    public final String integrationStatusAsString() {
        return this.integrationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponse)) {
            return false;
        }
        PutIntegrationResponse other = (PutIntegrationResponse)((Object)obj);
        return Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.integrationStatusAsString(), other.integrationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationResponse").add("IntegrationName", (Object)this.integrationName()).add("IntegrationStatus", (Object)this.integrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "integrationStatus": {
                return Optional.ofNullable(clazz.cast(this.integrationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("integrationName", INTEGRATION_NAME_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponse, T> g) {
        return obj -> g.apply((PutIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String integrationName;
        private String integrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponse model) {
            super(model);
            this.integrationName(model.integrationName);
            this.integrationStatus(model.integrationStatus);
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getIntegrationStatus() {
            return this.integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        @Override
        public PutIntegrationResponse build() {
            return new PutIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationResponse> {
        public Builder integrationName(String var1);

        public Builder integrationStatus(String var1);

        public Builder integrationStatus(IntegrationStatus var1);
    }
}

