/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;

public class DescribeLogStreamsIterable
implements SdkIterable<DescribeLogStreamsResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeLogStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLogStreamsIterable(CloudWatchLogsClient client, DescribeLogStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLogStreamsResponseFetcher();
    }

    public Iterator<DescribeLogStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LogStream> logStreams() {
        Function<DescribeLogStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logStreams() != null) {
                return response.logStreams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeLogStreamsIterable resume(DescribeLogStreamsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLogStreamsIterable(this.client, (DescribeLogStreamsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeLogStreamsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeLogStreamsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeLogStreamsResponseFetcher
    implements SyncPageFetcher<DescribeLogStreamsResponse> {
        private DescribeLogStreamsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLogStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLogStreamsResponse nextPage(DescribeLogStreamsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLogStreamsIterable.this.client.describeLogStreams(DescribeLogStreamsIterable.this.firstRequest);
            }
            return DescribeLogStreamsIterable.this.client.describeLogStreams((DescribeLogStreamsRequest)((Object)DescribeLogStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

