/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogStreamNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterLogEventsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, FilterLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::logGroupName)).setter(FilterLogEventsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::logGroupIdentifier)).setter(FilterLogEventsRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<List<String>> LOG_STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logStreamNames").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::logStreamNames)).setter(FilterLogEventsRequest.setter(Builder::logStreamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamNamePrefix").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::logStreamNamePrefix)).setter(FilterLogEventsRequest.setter(Builder::logStreamNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTime").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::startTime)).setter(FilterLogEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Long> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTime").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::endTime)).setter(FilterLogEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::filterPattern)).setter(FilterLogEventsRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::nextToken)).setter(FilterLogEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::limit)).setter(FilterLogEventsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<Boolean> INTERLEAVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("interleaved").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::interleaved)).setter(FilterLogEventsRequest.setter(Builder::interleaved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interleaved").build()}).build();
    private static final SdkField<Boolean> UNMASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("unmask").getter(FilterLogEventsRequest.getter(FilterLogEventsRequest::unmask)).setter(FilterLogEventsRequest.setter(Builder::unmask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, LOG_GROUP_IDENTIFIER_FIELD, LOG_STREAM_NAMES_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, START_TIME_FIELD, END_TIME_FIELD, FILTER_PATTERN_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD, INTERLEAVED_FIELD, UNMASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("logGroupName", LOG_GROUP_NAME_FIELD);
            this.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
            this.put("logStreamNames", LOG_STREAM_NAMES_FIELD);
            this.put("logStreamNamePrefix", LOG_STREAM_NAME_PREFIX_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("filterPattern", FILTER_PATTERN_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("limit", LIMIT_FIELD);
            this.put("interleaved", INTERLEAVED_FIELD);
            this.put("unmask", UNMASK_FIELD);
        }
    });
    private final String logGroupName;
    private final String logGroupIdentifier;
    private final List<String> logStreamNames;
    private final String logStreamNamePrefix;
    private final Long startTime;
    private final Long endTime;
    private final String filterPattern;
    private final String nextToken;
    private final Integer limit;
    private final Boolean interleaved;
    private final Boolean unmask;

    private FilterLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.logStreamNames = builder.logStreamNames;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.interleaved = builder.interleaved;
        this.unmask = builder.unmask;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final boolean hasLogStreamNames() {
        return this.logStreamNames != null && !(this.logStreamNames instanceof SdkAutoConstructList);
    }

    public final List<String> logStreamNames() {
        return this.logStreamNames;
    }

    public final String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public final Long startTime() {
        return this.startTime;
    }

    public final Long endTime() {
        return this.endTime;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Deprecated
    public final Boolean interleaved() {
        return this.interleaved;
    }

    public final Boolean unmask() {
        return this.unmask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogStreamNames() ? this.logStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.interleaved());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && this.hasLogStreamNames() == other.hasLogStreamNames() && Objects.equals(this.logStreamNames(), other.logStreamNames()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.interleaved(), other.interleaved()) && Objects.equals(this.unmask(), other.unmask());
    }

    public final String toString() {
        return ToString.builder((String)"FilterLogEventsRequest").add("LogGroupName", (Object)this.logGroupName()).add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("LogStreamNames", this.hasLogStreamNames() ? this.logStreamNames() : null).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("FilterPattern", (Object)this.filterPattern()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).add("Interleaved", (Object)this.interleaved()).add("Unmask", (Object)this.unmask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "logStreamNames": {
                return Optional.ofNullable(clazz.cast(this.logStreamNames()));
            }
            case "logStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "interleaved": {
                return Optional.ofNullable(clazz.cast(this.interleaved()));
            }
            case "unmask": {
                return Optional.ofNullable(clazz.cast(this.unmask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilterLogEventsRequest, T> g) {
        return obj -> g.apply((FilterLogEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logGroupIdentifier;
        private List<String> logStreamNames = DefaultSdkAutoConstructList.getInstance();
        private String logStreamNamePrefix;
        private Long startTime;
        private Long endTime;
        private String filterPattern;
        private String nextToken;
        private Integer limit;
        private Boolean interleaved;
        private Boolean unmask;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.logStreamNames(model.logStreamNames);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.filterPattern(model.filterPattern);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
            this.interleaved(model.interleaved);
            this.unmask(model.unmask);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final Collection<String> getLogStreamNames() {
            if (this.logStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logStreamNames;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @Override
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNames(String ... logStreamNames) {
            this.logStreamNames(Arrays.asList(logStreamNames));
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Deprecated
        public final Boolean getInterleaved() {
            return this.interleaved;
        }

        @Deprecated
        public final void setInterleaved(Boolean interleaved) {
            this.interleaved = interleaved;
        }

        @Override
        @Deprecated
        public final Builder interleaved(Boolean interleaved) {
            this.interleaved = interleaved;
            return this;
        }

        public final Boolean getUnmask() {
            return this.unmask;
        }

        public final void setUnmask(Boolean unmask) {
            this.unmask = unmask;
        }

        @Override
        public final Builder unmask(Boolean unmask) {
            this.unmask = unmask;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FilterLogEventsRequest build() {
            return new FilterLogEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, FilterLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logGroupIdentifier(String var1);

        public Builder logStreamNames(Collection<String> var1);

        public Builder logStreamNames(String ... var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder filterPattern(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        @Deprecated
        public Builder interleaved(Boolean var1);

        public Builder unmask(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

