/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogGroupFieldsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetLogGroupFieldsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(GetLogGroupFieldsRequest.getter(GetLogGroupFieldsRequest::logGroupName)).setter(GetLogGroupFieldsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Long> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("time").getter(GetLogGroupFieldsRequest.getter(GetLogGroupFieldsRequest::time)).setter(GetLogGroupFieldsRequest.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()}).build();
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(GetLogGroupFieldsRequest.getter(GetLogGroupFieldsRequest::logGroupIdentifier)).setter(GetLogGroupFieldsRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, TIME_FIELD, LOG_GROUP_IDENTIFIER_FIELD));
    private final String logGroupName;
    private final Long time;
    private final String logGroupIdentifier;

    private GetLogGroupFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.time = builder.time;
        this.logGroupIdentifier = builder.logGroupIdentifier;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Long time() {
        return this.time;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogGroupFieldsRequest)) {
            return false;
        }
        GetLogGroupFieldsRequest other = (GetLogGroupFieldsRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetLogGroupFieldsRequest").add("LogGroupName", (Object)this.logGroupName()).add("Time", (Object)this.time()).add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogGroupFieldsRequest, T> g) {
        return obj -> g.apply((GetLogGroupFieldsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long time;
        private String logGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogGroupFieldsRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.time(model.time);
            this.logGroupIdentifier(model.logGroupIdentifier);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Long getTime() {
            return this.time;
        }

        public final void setTime(Long time) {
            this.time = time;
        }

        @Override
        public final Builder time(Long time) {
            this.time = time;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogGroupFieldsRequest build() {
            return new GetLogGroupFieldsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogGroupFieldsRequest> {
        public Builder logGroupName(String var1);

        public Builder time(Long var1);

        public Builder logGroupIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

