/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.HistogramCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupArnListCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogSamplesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.PatternToken;
import software.amazon.awssdk.services.cloudwatchlogs.model.PatternTokensCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anomaly> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyId").getter(Anomaly.getter(Anomaly::anomalyId)).setter(Anomaly.setter(Builder::anomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyId").build()}).build();
    private static final SdkField<String> PATTERN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternId").getter(Anomaly.getter(Anomaly::patternId)).setter(Anomaly.setter(Builder::patternId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternId").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(Anomaly.getter(Anomaly::anomalyDetectorArn)).setter(Anomaly.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final SdkField<String> PATTERN_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternString").getter(Anomaly.getter(Anomaly::patternString)).setter(Anomaly.setter(Builder::patternString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternString").build()}).build();
    private static final SdkField<String> PATTERN_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternRegex").getter(Anomaly.getter(Anomaly::patternRegex)).setter(Anomaly.setter(Builder::patternRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternRegex").build()}).build();
    private static final SdkField<String> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("priority").getter(Anomaly.getter(Anomaly::priority)).setter(Anomaly.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Long> FIRST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("firstSeen").getter(Anomaly.getter(Anomaly::firstSeen)).setter(Anomaly.setter(Builder::firstSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build()}).build();
    private static final SdkField<Long> LAST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastSeen").getter(Anomaly.getter(Anomaly::lastSeen)).setter(Anomaly.setter(Builder::lastSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Anomaly.getter(Anomaly::description)).setter(Anomaly.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(Anomaly.getter(Anomaly::active)).setter(Anomaly.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Anomaly.getter(Anomaly::stateAsString)).setter(Anomaly.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, Long>> HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("histogram").getter(Anomaly.getter(Anomaly::histogram)).setter(Anomaly.setter(Builder::histogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("histogram").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_SAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logSamples").getter(Anomaly.getter(Anomaly::logSamples)).setter(Anomaly.setter(Builder::logSamples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSamples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PatternToken>> PATTERN_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("patternTokens").getter(Anomaly.getter(Anomaly::patternTokens)).setter(Anomaly.setter(Builder::patternTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatternToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupArnList").getter(Anomaly.getter(Anomaly::logGroupArnList)).setter(Anomaly.setter(Builder::logGroupArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suppressed").getter(Anomaly.getter(Anomaly::suppressed)).setter(Anomaly.setter(Builder::suppressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressed").build()}).build();
    private static final SdkField<Long> SUPPRESSED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("suppressedDate").getter(Anomaly.getter(Anomaly::suppressedDate)).setter(Anomaly.setter(Builder::suppressedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressedDate").build()}).build();
    private static final SdkField<Long> SUPPRESSED_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("suppressedUntil").getter(Anomaly.getter(Anomaly::suppressedUntil)).setter(Anomaly.setter(Builder::suppressedUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressedUntil").build()}).build();
    private static final SdkField<Boolean> IS_PATTERN_LEVEL_SUPPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPatternLevelSuppression").getter(Anomaly.getter(Anomaly::isPatternLevelSuppression)).setter(Anomaly.setter(Builder::isPatternLevelSuppression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPatternLevelSuppression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD, PATTERN_ID_FIELD, ANOMALY_DETECTOR_ARN_FIELD, PATTERN_STRING_FIELD, PATTERN_REGEX_FIELD, PRIORITY_FIELD, FIRST_SEEN_FIELD, LAST_SEEN_FIELD, DESCRIPTION_FIELD, ACTIVE_FIELD, STATE_FIELD, HISTOGRAM_FIELD, LOG_SAMPLES_FIELD, PATTERN_TOKENS_FIELD, LOG_GROUP_ARN_LIST_FIELD, SUPPRESSED_FIELD, SUPPRESSED_DATE_FIELD, SUPPRESSED_UNTIL_FIELD, IS_PATTERN_LEVEL_SUPPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String anomalyId;
    private final String patternId;
    private final String anomalyDetectorArn;
    private final String patternString;
    private final String patternRegex;
    private final String priority;
    private final Long firstSeen;
    private final Long lastSeen;
    private final String description;
    private final Boolean active;
    private final String state;
    private final Map<String, Long> histogram;
    private final List<String> logSamples;
    private final List<PatternToken> patternTokens;
    private final List<String> logGroupArnList;
    private final Boolean suppressed;
    private final Long suppressedDate;
    private final Long suppressedUntil;
    private final Boolean isPatternLevelSuppression;

    private Anomaly(BuilderImpl builder) {
        this.anomalyId = builder.anomalyId;
        this.patternId = builder.patternId;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.patternString = builder.patternString;
        this.patternRegex = builder.patternRegex;
        this.priority = builder.priority;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
        this.description = builder.description;
        this.active = builder.active;
        this.state = builder.state;
        this.histogram = builder.histogram;
        this.logSamples = builder.logSamples;
        this.patternTokens = builder.patternTokens;
        this.logGroupArnList = builder.logGroupArnList;
        this.suppressed = builder.suppressed;
        this.suppressedDate = builder.suppressedDate;
        this.suppressedUntil = builder.suppressedUntil;
        this.isPatternLevelSuppression = builder.isPatternLevelSuppression;
    }

    public final String anomalyId() {
        return this.anomalyId;
    }

    public final String patternId() {
        return this.patternId;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String patternString() {
        return this.patternString;
    }

    public final String patternRegex() {
        return this.patternRegex;
    }

    public final String priority() {
        return this.priority;
    }

    public final Long firstSeen() {
        return this.firstSeen;
    }

    public final Long lastSeen() {
        return this.lastSeen;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean active() {
        return this.active;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasHistogram() {
        return this.histogram != null && !(this.histogram instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> histogram() {
        return this.histogram;
    }

    public final boolean hasLogSamples() {
        return this.logSamples != null && !(this.logSamples instanceof SdkAutoConstructList);
    }

    public final List<String> logSamples() {
        return this.logSamples;
    }

    public final boolean hasPatternTokens() {
        return this.patternTokens != null && !(this.patternTokens instanceof SdkAutoConstructList);
    }

    public final List<PatternToken> patternTokens() {
        return this.patternTokens;
    }

    public final boolean hasLogGroupArnList() {
        return this.logGroupArnList != null && !(this.logGroupArnList instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupArnList() {
        return this.logGroupArnList;
    }

    public final Boolean suppressed() {
        return this.suppressed;
    }

    public final Long suppressedDate() {
        return this.suppressedDate;
    }

    public final Long suppressedUntil() {
        return this.suppressedUntil;
    }

    public final Boolean isPatternLevelSuppression() {
        return this.isPatternLevelSuppression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternString());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternRegex());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistogram() ? this.histogram() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogSamples() ? this.logSamples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatternTokens() ? this.patternTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupArnList() ? this.logGroupArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPatternLevelSuppression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        return Objects.equals(this.anomalyId(), other.anomalyId()) && Objects.equals(this.patternId(), other.patternId()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.patternString(), other.patternString()) && Objects.equals(this.patternRegex(), other.patternRegex()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.firstSeen(), other.firstSeen()) && Objects.equals(this.lastSeen(), other.lastSeen()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasHistogram() == other.hasHistogram() && Objects.equals(this.histogram(), other.histogram()) && this.hasLogSamples() == other.hasLogSamples() && Objects.equals(this.logSamples(), other.logSamples()) && this.hasPatternTokens() == other.hasPatternTokens() && Objects.equals(this.patternTokens(), other.patternTokens()) && this.hasLogGroupArnList() == other.hasLogGroupArnList() && Objects.equals(this.logGroupArnList(), other.logGroupArnList()) && Objects.equals(this.suppressed(), other.suppressed()) && Objects.equals(this.suppressedDate(), other.suppressedDate()) && Objects.equals(this.suppressedUntil(), other.suppressedUntil()) && Objects.equals(this.isPatternLevelSuppression(), other.isPatternLevelSuppression());
    }

    public final String toString() {
        return ToString.builder((String)"Anomaly").add("AnomalyId", (Object)this.anomalyId()).add("PatternId", (Object)this.patternId()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("PatternString", (Object)this.patternString()).add("PatternRegex", (Object)this.patternRegex()).add("Priority", (Object)this.priority()).add("FirstSeen", (Object)this.firstSeen()).add("LastSeen", (Object)this.lastSeen()).add("Description", (Object)this.description()).add("Active", (Object)this.active()).add("State", (Object)this.stateAsString()).add("Histogram", this.hasHistogram() ? this.histogram() : null).add("LogSamples", this.hasLogSamples() ? this.logSamples() : null).add("PatternTokens", this.hasPatternTokens() ? this.patternTokens() : null).add("LogGroupArnList", this.hasLogGroupArnList() ? this.logGroupArnList() : null).add("Suppressed", (Object)this.suppressed()).add("SuppressedDate", (Object)this.suppressedDate()).add("SuppressedUntil", (Object)this.suppressedUntil()).add("IsPatternLevelSuppression", (Object)this.isPatternLevelSuppression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyId": {
                return Optional.ofNullable(clazz.cast(this.anomalyId()));
            }
            case "patternId": {
                return Optional.ofNullable(clazz.cast(this.patternId()));
            }
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "patternString": {
                return Optional.ofNullable(clazz.cast(this.patternString()));
            }
            case "patternRegex": {
                return Optional.ofNullable(clazz.cast(this.patternRegex()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "firstSeen": {
                return Optional.ofNullable(clazz.cast(this.firstSeen()));
            }
            case "lastSeen": {
                return Optional.ofNullable(clazz.cast(this.lastSeen()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "histogram": {
                return Optional.ofNullable(clazz.cast(this.histogram()));
            }
            case "logSamples": {
                return Optional.ofNullable(clazz.cast(this.logSamples()));
            }
            case "patternTokens": {
                return Optional.ofNullable(clazz.cast(this.patternTokens()));
            }
            case "logGroupArnList": {
                return Optional.ofNullable(clazz.cast(this.logGroupArnList()));
            }
            case "suppressed": {
                return Optional.ofNullable(clazz.cast(this.suppressed()));
            }
            case "suppressedDate": {
                return Optional.ofNullable(clazz.cast(this.suppressedDate()));
            }
            case "suppressedUntil": {
                return Optional.ofNullable(clazz.cast(this.suppressedUntil()));
            }
            case "isPatternLevelSuppression": {
                return Optional.ofNullable(clazz.cast(this.isPatternLevelSuppression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anomalyId;
        private String patternId;
        private String anomalyDetectorArn;
        private String patternString;
        private String patternRegex;
        private String priority;
        private Long firstSeen;
        private Long lastSeen;
        private String description;
        private Boolean active;
        private String state;
        private Map<String, Long> histogram = DefaultSdkAutoConstructMap.getInstance();
        private List<String> logSamples = DefaultSdkAutoConstructList.getInstance();
        private List<PatternToken> patternTokens = DefaultSdkAutoConstructList.getInstance();
        private List<String> logGroupArnList = DefaultSdkAutoConstructList.getInstance();
        private Boolean suppressed;
        private Long suppressedDate;
        private Long suppressedUntil;
        private Boolean isPatternLevelSuppression;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            this.anomalyId(model.anomalyId);
            this.patternId(model.patternId);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.patternString(model.patternString);
            this.patternRegex(model.patternRegex);
            this.priority(model.priority);
            this.firstSeen(model.firstSeen);
            this.lastSeen(model.lastSeen);
            this.description(model.description);
            this.active(model.active);
            this.state(model.state);
            this.histogram(model.histogram);
            this.logSamples(model.logSamples);
            this.patternTokens(model.patternTokens);
            this.logGroupArnList(model.logGroupArnList);
            this.suppressed(model.suppressed);
            this.suppressedDate(model.suppressedDate);
            this.suppressedUntil(model.suppressedUntil);
            this.isPatternLevelSuppression(model.isPatternLevelSuppression);
        }

        public final String getAnomalyId() {
            return this.anomalyId;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final String getPatternId() {
            return this.patternId;
        }

        public final void setPatternId(String patternId) {
            this.patternId = patternId;
        }

        @Override
        public final Builder patternId(String patternId) {
            this.patternId = patternId;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getPatternString() {
            return this.patternString;
        }

        public final void setPatternString(String patternString) {
            this.patternString = patternString;
        }

        @Override
        public final Builder patternString(String patternString) {
            this.patternString = patternString;
            return this;
        }

        public final String getPatternRegex() {
            return this.patternRegex;
        }

        public final void setPatternRegex(String patternRegex) {
            this.patternRegex = patternRegex;
        }

        @Override
        public final Builder patternRegex(String patternRegex) {
            this.patternRegex = patternRegex;
            return this;
        }

        public final String getPriority() {
            return this.priority;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final Long getFirstSeen() {
            return this.firstSeen;
        }

        public final void setFirstSeen(Long firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(Long firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final Long getLastSeen() {
            return this.lastSeen;
        }

        public final void setLastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, Long> getHistogram() {
            if (this.histogram instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.histogram;
        }

        public final void setHistogram(Map<String, Long> histogram) {
            this.histogram = HistogramCopier.copy(histogram);
        }

        @Override
        public final Builder histogram(Map<String, Long> histogram) {
            this.histogram = HistogramCopier.copy(histogram);
            return this;
        }

        public final Collection<String> getLogSamples() {
            if (this.logSamples instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logSamples;
        }

        public final void setLogSamples(Collection<String> logSamples) {
            this.logSamples = LogSamplesCopier.copy(logSamples);
        }

        @Override
        public final Builder logSamples(Collection<String> logSamples) {
            this.logSamples = LogSamplesCopier.copy(logSamples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logSamples(String ... logSamples) {
            this.logSamples(Arrays.asList(logSamples));
            return this;
        }

        public final List<PatternToken.Builder> getPatternTokens() {
            List<PatternToken.Builder> result = PatternTokensCopier.copyToBuilder(this.patternTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatternTokens(Collection<PatternToken.BuilderImpl> patternTokens) {
            this.patternTokens = PatternTokensCopier.copyFromBuilder(patternTokens);
        }

        @Override
        public final Builder patternTokens(Collection<PatternToken> patternTokens) {
            this.patternTokens = PatternTokensCopier.copy(patternTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patternTokens(PatternToken ... patternTokens) {
            this.patternTokens(Arrays.asList(patternTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patternTokens(Consumer<PatternToken.Builder> ... patternTokens) {
            this.patternTokens(Stream.of(patternTokens).map(c -> (PatternToken)((PatternToken.Builder)PatternToken.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLogGroupArnList() {
            if (this.logGroupArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupArnList;
        }

        public final void setLogGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
        }

        @Override
        public final Builder logGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupArnList(String ... logGroupArnList) {
            this.logGroupArnList(Arrays.asList(logGroupArnList));
            return this;
        }

        public final Boolean getSuppressed() {
            return this.suppressed;
        }

        public final void setSuppressed(Boolean suppressed) {
            this.suppressed = suppressed;
        }

        @Override
        public final Builder suppressed(Boolean suppressed) {
            this.suppressed = suppressed;
            return this;
        }

        public final Long getSuppressedDate() {
            return this.suppressedDate;
        }

        public final void setSuppressedDate(Long suppressedDate) {
            this.suppressedDate = suppressedDate;
        }

        @Override
        public final Builder suppressedDate(Long suppressedDate) {
            this.suppressedDate = suppressedDate;
            return this;
        }

        public final Long getSuppressedUntil() {
            return this.suppressedUntil;
        }

        public final void setSuppressedUntil(Long suppressedUntil) {
            this.suppressedUntil = suppressedUntil;
        }

        @Override
        public final Builder suppressedUntil(Long suppressedUntil) {
            this.suppressedUntil = suppressedUntil;
            return this;
        }

        public final Boolean getIsPatternLevelSuppression() {
            return this.isPatternLevelSuppression;
        }

        public final void setIsPatternLevelSuppression(Boolean isPatternLevelSuppression) {
            this.isPatternLevelSuppression = isPatternLevelSuppression;
        }

        @Override
        public final Builder isPatternLevelSuppression(Boolean isPatternLevelSuppression) {
            this.isPatternLevelSuppression = isPatternLevelSuppression;
            return this;
        }

        public Anomaly build() {
            return new Anomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anomaly> {
        public Builder anomalyId(String var1);

        public Builder patternId(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder patternString(String var1);

        public Builder patternRegex(String var1);

        public Builder priority(String var1);

        public Builder firstSeen(Long var1);

        public Builder lastSeen(Long var1);

        public Builder description(String var1);

        public Builder active(Boolean var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder histogram(Map<String, Long> var1);

        public Builder logSamples(Collection<String> var1);

        public Builder logSamples(String ... var1);

        public Builder patternTokens(Collection<PatternToken> var1);

        public Builder patternTokens(PatternToken ... var1);

        public Builder patternTokens(Consumer<PatternToken.Builder> ... var1);

        public Builder logGroupArnList(Collection<String> var1);

        public Builder logGroupArnList(String ... var1);

        public Builder suppressed(Boolean var1);

        public Builder suppressedDate(Long var1);

        public Builder suppressedUntil(Long var1);

        public Builder isPatternLevelSuppression(Boolean var1);
    }
}

