/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.DefaultCloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.DefaultCloudWatchLogsBaseClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.endpoints.CloudWatchLogsEndpointProvider;

@SdkInternalApi
final class DefaultCloudWatchLogsAsyncClientBuilder
extends DefaultCloudWatchLogsBaseClientBuilder<CloudWatchLogsAsyncClientBuilder, CloudWatchLogsAsyncClient>
implements CloudWatchLogsAsyncClientBuilder {
    DefaultCloudWatchLogsAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudWatchLogsAsyncClientBuilder endpointProvider(CloudWatchLogsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudWatchLogsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudWatchLogsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudWatchLogsServiceClientConfiguration serviceClientConfiguration = CloudWatchLogsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudWatchLogsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

