/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;

public class DescribeSubscriptionFiltersIterable
implements SdkIterable<DescribeSubscriptionFiltersResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeSubscriptionFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSubscriptionFiltersIterable(CloudWatchLogsClient client, DescribeSubscriptionFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSubscriptionFiltersResponseFetcher();
    }

    public Iterator<DescribeSubscriptionFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscriptionFilter> subscriptionFilters() {
        Function<DescribeSubscriptionFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptionFilters() != null) {
                return response.subscriptionFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSubscriptionFiltersResponseFetcher
    implements SyncPageFetcher<DescribeSubscriptionFiltersResponse> {
        private DescribeSubscriptionFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubscriptionFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSubscriptionFiltersResponse nextPage(DescribeSubscriptionFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubscriptionFiltersIterable.this.client.describeSubscriptionFilters(DescribeSubscriptionFiltersIterable.this.firstRequest);
            }
            return DescribeSubscriptionFiltersIterable.this.client.describeSubscriptionFilters((DescribeSubscriptionFiltersRequest)((Object)DescribeSubscriptionFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

