/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTask;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTasksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportTasksResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportTask>> EXPORT_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportTasks").getter(DescribeExportTasksResponse.getter(DescribeExportTasksResponse::exportTasks)).setter(DescribeExportTasksResponse.setter(Builder::exportTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeExportTasksResponse.getter(DescribeExportTasksResponse::nextToken)).setter(DescribeExportTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExportTask> exportTasks;
    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportTasks = builder.exportTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExportTasks() {
        return this.exportTasks != null && !(this.exportTasks instanceof SdkAutoConstructList);
    }

    public final List<ExportTask> exportTasks() {
        return this.exportTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportTasks() ? this.exportTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        return this.hasExportTasks() == other.hasExportTasks() && Objects.equals(this.exportTasks(), other.exportTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExportTasksResponse").add("ExportTasks", this.hasExportTasks() ? this.exportTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportTasks": {
                return Optional.ofNullable(clazz.cast(this.exportTasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            this.exportTasks(model.exportTasks);
            this.nextToken(model.nextToken);
        }

        public final List<ExportTask.Builder> getExportTasks() {
            List<ExportTask.Builder> result = ExportTasksCopier.copyToBuilder(this.exportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask ... exportTasks) {
            this.exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder> ... exportTasks) {
            this.exportTasks(Stream.of(exportTasks).map(c -> (ExportTask)((ExportTask.Builder)ExportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTasksCopier.copyFromBuilder(exportTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportTasks(Collection<ExportTask> var1);

        public Builder exportTasks(ExportTask ... var1);

        public Builder exportTasks(Consumer<ExportTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

