/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.model.ContributorAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmContributor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmContributor> {
    private static final SdkField<String> CONTRIBUTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContributorId").getter(AlarmContributor.getter(AlarmContributor::contributorId)).setter(AlarmContributor.setter(Builder::contributorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorId").build()}).build();
    private static final SdkField<Map<String, String>> CONTRIBUTOR_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ContributorAttributes").getter(AlarmContributor.getter(AlarmContributor::contributorAttributes)).setter(AlarmContributor.setter(Builder::contributorAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(AlarmContributor.getter(AlarmContributor::stateReason)).setter(AlarmContributor.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> STATE_TRANSITIONED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateTransitionedTimestamp").getter(AlarmContributor.getter(AlarmContributor::stateTransitionedTimestamp)).setter(AlarmContributor.setter(Builder::stateTransitionedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRIBUTOR_ID_FIELD, CONTRIBUTOR_ATTRIBUTES_FIELD, STATE_REASON_FIELD, STATE_TRANSITIONED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmContributor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contributorId;
    private final Map<String, String> contributorAttributes;
    private final String stateReason;
    private final Instant stateTransitionedTimestamp;

    private AlarmContributor(BuilderImpl builder) {
        this.contributorId = builder.contributorId;
        this.contributorAttributes = builder.contributorAttributes;
        this.stateReason = builder.stateReason;
        this.stateTransitionedTimestamp = builder.stateTransitionedTimestamp;
    }

    public final String contributorId() {
        return this.contributorId;
    }

    public final boolean hasContributorAttributes() {
        return this.contributorAttributes != null && !(this.contributorAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> contributorAttributes() {
        return this.contributorAttributes;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Instant stateTransitionedTimestamp() {
        return this.stateTransitionedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contributorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributorAttributes() ? this.contributorAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmContributor)) {
            return false;
        }
        AlarmContributor other = (AlarmContributor)obj;
        return Objects.equals(this.contributorId(), other.contributorId()) && this.hasContributorAttributes() == other.hasContributorAttributes() && Objects.equals(this.contributorAttributes(), other.contributorAttributes()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateTransitionedTimestamp(), other.stateTransitionedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmContributor").add("ContributorId", (Object)this.contributorId()).add("ContributorAttributes", this.hasContributorAttributes() ? this.contributorAttributes() : null).add("StateReason", (Object)this.stateReason()).add("StateTransitionedTimestamp", (Object)this.stateTransitionedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContributorId": {
                return Optional.ofNullable(clazz.cast(this.contributorId()));
            }
            case "ContributorAttributes": {
                return Optional.ofNullable(clazz.cast(this.contributorAttributes()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateTransitionedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContributorId", CONTRIBUTOR_ID_FIELD);
        map.put("ContributorAttributes", CONTRIBUTOR_ATTRIBUTES_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("StateTransitionedTimestamp", STATE_TRANSITIONED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmContributor, T> g) {
        return obj -> g.apply((AlarmContributor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contributorId;
        private Map<String, String> contributorAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String stateReason;
        private Instant stateTransitionedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmContributor model) {
            this.contributorId(model.contributorId);
            this.contributorAttributes(model.contributorAttributes);
            this.stateReason(model.stateReason);
            this.stateTransitionedTimestamp(model.stateTransitionedTimestamp);
        }

        public final String getContributorId() {
            return this.contributorId;
        }

        public final void setContributorId(String contributorId) {
            this.contributorId = contributorId;
        }

        @Override
        public final Builder contributorId(String contributorId) {
            this.contributorId = contributorId;
            return this;
        }

        public final Map<String, String> getContributorAttributes() {
            if (this.contributorAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.contributorAttributes;
        }

        public final void setContributorAttributes(Map<String, String> contributorAttributes) {
            this.contributorAttributes = ContributorAttributesCopier.copy(contributorAttributes);
        }

        @Override
        public final Builder contributorAttributes(Map<String, String> contributorAttributes) {
            this.contributorAttributes = ContributorAttributesCopier.copy(contributorAttributes);
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getStateTransitionedTimestamp() {
            return this.stateTransitionedTimestamp;
        }

        public final void setStateTransitionedTimestamp(Instant stateTransitionedTimestamp) {
            this.stateTransitionedTimestamp = stateTransitionedTimestamp;
        }

        @Override
        public final Builder stateTransitionedTimestamp(Instant stateTransitionedTimestamp) {
            this.stateTransitionedTimestamp = stateTransitionedTimestamp;
            return this;
        }

        public AlarmContributor build() {
            return new AlarmContributor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmContributor> {
        public Builder contributorId(String var1);

        public Builder contributorAttributes(Map<String, String> var1);

        public Builder stateReason(String var1);

        public Builder stateTransitionedTimestamp(Instant var1);
    }
}

