/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmContributorsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmContributorsResponse.Builder, DescribeAlarmContributorsResponse> {
    private static final SdkField<List<AlarmContributor>> ALARM_CONTRIBUTORS_FIELD = SdkField
            .<List<AlarmContributor>> builder(MarshallingType.LIST)
            .memberName("AlarmContributors")
            .getter(getter(DescribeAlarmContributorsResponse::alarmContributors))
            .setter(setter(Builder::alarmContributors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmContributors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmContributor> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmContributor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAlarmContributorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_CONTRIBUTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AlarmContributor> alarmContributors;

    private final String nextToken;

    private DescribeAlarmContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmContributors = builder.alarmContributors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmContributors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlarmContributors() {
        return alarmContributors != null && !(alarmContributors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of alarm contributors that provide details about the individual time series contributing to the alarm's
     * state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmContributors} method.
     * </p>
     * 
     * @return A list of alarm contributors that provide details about the individual time series contributing to the
     *         alarm's state.
     */
    public final List<AlarmContributor> alarmContributors() {
        return alarmContributors;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmContributors() ? alarmContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmContributorsResponse)) {
            return false;
        }
        DescribeAlarmContributorsResponse other = (DescribeAlarmContributorsResponse) obj;
        return hasAlarmContributors() == other.hasAlarmContributors()
                && Objects.equals(alarmContributors(), other.alarmContributors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmContributorsResponse")
                .add("AlarmContributors", hasAlarmContributors() ? alarmContributors() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmContributors":
            return Optional.ofNullable(clazz.cast(alarmContributors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlarmContributors", ALARM_CONTRIBUTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmContributorsResponse, T> g) {
        return obj -> g.apply((DescribeAlarmContributorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAlarmContributorsResponse> {
        /**
         * <p>
         * A list of alarm contributors that provide details about the individual time series contributing to the
         * alarm's state.
         * </p>
         * 
         * @param alarmContributors
         *        A list of alarm contributors that provide details about the individual time series contributing to the
         *        alarm's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmContributors(Collection<AlarmContributor> alarmContributors);

        /**
         * <p>
         * A list of alarm contributors that provide details about the individual time series contributing to the
         * alarm's state.
         * </p>
         * 
         * @param alarmContributors
         *        A list of alarm contributors that provide details about the individual time series contributing to the
         *        alarm's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmContributors(AlarmContributor... alarmContributors);

        /**
         * <p>
         * A list of alarm contributors that provide details about the individual time series contributing to the
         * alarm's state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.AlarmContributor.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatch.model.AlarmContributor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.AlarmContributor.Builder#build()} is called
         * immediately and its result is passed to {@link #alarmContributors(List<AlarmContributor>)}.
         * 
         * @param alarmContributors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.AlarmContributor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmContributors(java.util.Collection<AlarmContributor>)
         */
        Builder alarmContributors(Consumer<AlarmContributor.Builder>... alarmContributors);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<AlarmContributor> alarmContributors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmContributorsResponse model) {
            super(model);
            alarmContributors(model.alarmContributors);
            nextToken(model.nextToken);
        }

        public final List<AlarmContributor.Builder> getAlarmContributors() {
            List<AlarmContributor.Builder> result = AlarmContributorsCopier.copyToBuilder(this.alarmContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmContributors(Collection<AlarmContributor.BuilderImpl> alarmContributors) {
            this.alarmContributors = AlarmContributorsCopier.copyFromBuilder(alarmContributors);
        }

        @Override
        public final Builder alarmContributors(Collection<AlarmContributor> alarmContributors) {
            this.alarmContributors = AlarmContributorsCopier.copy(alarmContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmContributors(AlarmContributor... alarmContributors) {
            alarmContributors(Arrays.asList(alarmContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmContributors(Consumer<AlarmContributor.Builder>... alarmContributors) {
            alarmContributors(Stream.of(alarmContributors).map(c -> AlarmContributor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAlarmContributorsResponse build() {
            return new DescribeAlarmContributorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
