/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse;

public class DescribeInsightRulesPublisher
implements SdkPublisher<DescribeInsightRulesResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeInsightRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInsightRulesPublisher(CloudWatchAsyncClient client, DescribeInsightRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInsightRulesPublisher(CloudWatchAsyncClient client, DescribeInsightRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInsightRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInsightRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeInsightRulesResponseFetcher
    implements AsyncPageFetcher<DescribeInsightRulesResponse> {
        private DescribeInsightRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInsightRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInsightRulesResponse> nextPage(DescribeInsightRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInsightRulesPublisher.this.client.describeInsightRules(DescribeInsightRulesPublisher.this.firstRequest);
            }
            return DescribeInsightRulesPublisher.this.client.describeInsightRules((DescribeInsightRulesRequest)((Object)DescribeInsightRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

