/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;

public class ListMetricsPublisher
implements SdkPublisher<ListMetricsResponse> {
    private final CloudWatchAsyncClient client;
    private final ListMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricsPublisher(CloudWatchAsyncClient client, ListMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricsPublisher(CloudWatchAsyncClient client, ListMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Metric> metrics() {
        Function<ListMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<String> owningAccounts() {
        Function<ListMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.owningAccounts() != null) {
                return response.owningAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMetricsResponseFetcher
    implements AsyncPageFetcher<ListMetricsResponse> {
        private ListMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricsResponse> nextPage(ListMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricsPublisher.this.client.listMetrics(ListMetricsPublisher.this.firstRequest);
            }
            return ListMetricsPublisher.this.client.listMetrics((ListMetricsRequest)((Object)ListMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

