/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse;

public class DescribeInsightRulesIterable
implements SdkIterable<DescribeInsightRulesResponse> {
    private final CloudWatchClient client;
    private final DescribeInsightRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInsightRulesIterable(CloudWatchClient client, DescribeInsightRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInsightRulesResponseFetcher();
    }

    public Iterator<DescribeInsightRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeInsightRulesResponseFetcher
    implements SyncPageFetcher<DescribeInsightRulesResponse> {
        private DescribeInsightRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInsightRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInsightRulesResponse nextPage(DescribeInsightRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInsightRulesIterable.this.client.describeInsightRules(DescribeInsightRulesIterable.this.firstRequest);
            }
            return DescribeInsightRulesIterable.this.client.describeInsightRules((DescribeInsightRulesRequest)((Object)DescribeInsightRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

