/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorExcludedTimeRangesCopier;
import software.amazon.awssdk.services.cloudwatch.model.Range;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetectorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetectorConfiguration> {
    private static final SdkField<List<Range>> EXCLUDED_TIME_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedTimeRanges").getter(AnomalyDetectorConfiguration.getter(AnomalyDetectorConfiguration::excludedTimeRanges)).setter(AnomalyDetectorConfiguration.setter(Builder::excludedTimeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedTimeRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricTimezone").getter(AnomalyDetectorConfiguration.getter(AnomalyDetectorConfiguration::metricTimezone)).setter(AnomalyDetectorConfiguration.setter(Builder::metricTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricTimezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDED_TIME_RANGES_FIELD, METRIC_TIMEZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExcludedTimeRanges", EXCLUDED_TIME_RANGES_FIELD);
            this.put("MetricTimezone", METRIC_TIMEZONE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Range> excludedTimeRanges;
    private final String metricTimezone;

    private AnomalyDetectorConfiguration(BuilderImpl builder) {
        this.excludedTimeRanges = builder.excludedTimeRanges;
        this.metricTimezone = builder.metricTimezone;
    }

    public final boolean hasExcludedTimeRanges() {
        return this.excludedTimeRanges != null && !(this.excludedTimeRanges instanceof SdkAutoConstructList);
    }

    public final List<Range> excludedTimeRanges() {
        return this.excludedTimeRanges;
    }

    public final String metricTimezone() {
        return this.metricTimezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedTimeRanges() ? this.excludedTimeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTimezone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorConfiguration)) {
            return false;
        }
        AnomalyDetectorConfiguration other = (AnomalyDetectorConfiguration)obj;
        return this.hasExcludedTimeRanges() == other.hasExcludedTimeRanges() && Objects.equals(this.excludedTimeRanges(), other.excludedTimeRanges()) && Objects.equals(this.metricTimezone(), other.metricTimezone());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetectorConfiguration").add("ExcludedTimeRanges", this.hasExcludedTimeRanges() ? this.excludedTimeRanges() : null).add("MetricTimezone", (Object)this.metricTimezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcludedTimeRanges": {
                return Optional.ofNullable(clazz.cast(this.excludedTimeRanges()));
            }
            case "MetricTimezone": {
                return Optional.ofNullable(clazz.cast(this.metricTimezone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorConfiguration, T> g) {
        return obj -> g.apply((AnomalyDetectorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Range> excludedTimeRanges = DefaultSdkAutoConstructList.getInstance();
        private String metricTimezone;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorConfiguration model) {
            this.excludedTimeRanges(model.excludedTimeRanges);
            this.metricTimezone(model.metricTimezone);
        }

        public final List<Range.Builder> getExcludedTimeRanges() {
            List<Range.Builder> result = AnomalyDetectorExcludedTimeRangesCopier.copyToBuilder(this.excludedTimeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludedTimeRanges(Collection<Range.BuilderImpl> excludedTimeRanges) {
            this.excludedTimeRanges = AnomalyDetectorExcludedTimeRangesCopier.copyFromBuilder(excludedTimeRanges);
        }

        @Override
        public final Builder excludedTimeRanges(Collection<Range> excludedTimeRanges) {
            this.excludedTimeRanges = AnomalyDetectorExcludedTimeRangesCopier.copy(excludedTimeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedTimeRanges(Range ... excludedTimeRanges) {
            this.excludedTimeRanges(Arrays.asList(excludedTimeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedTimeRanges(Consumer<Range.Builder> ... excludedTimeRanges) {
            this.excludedTimeRanges(Stream.of(excludedTimeRanges).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricTimezone() {
            return this.metricTimezone;
        }

        public final void setMetricTimezone(String metricTimezone) {
            this.metricTimezone = metricTimezone;
        }

        @Override
        public final Builder metricTimezone(String metricTimezone) {
            this.metricTimezone = metricTimezone;
            return this;
        }

        public AnomalyDetectorConfiguration build() {
            return new AnomalyDetectorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetectorConfiguration> {
        public Builder excludedTimeRanges(Collection<Range> var1);

        public Builder excludedTimeRanges(Range ... var1);

        public Builder excludedTimeRanges(Consumer<Range.Builder> ... var1);

        public Builder metricTimezone(String var1);
    }
}

