/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricAlarm
implements ToCopyableBuilder<Builder, MetricAlarm> {
    private final String alarmName;
    private final String alarmArn;
    private final String alarmDescription;
    private final Instant alarmConfigurationUpdatedTimestamp;
    private final Boolean actionsEnabled;
    private final List<String> okActions;
    private final List<String> alarmActions;
    private final List<String> insufficientDataActions;
    private final String stateValue;
    private final String stateReason;
    private final String stateReasonData;
    private final Instant stateUpdatedTimestamp;
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;
    private final Integer evaluationPeriods;
    private final Double threshold;
    private final String comparisonOperator;
    private final String treatMissingData;
    private final String evaluateLowSampleCountPercentile;

    private MetricAlarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmArn = builder.alarmArn;
        this.alarmDescription = builder.alarmDescription;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
        this.stateUpdatedTimestamp = builder.stateUpdatedTimestamp;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmArn() {
        return this.alarmArn;
    }

    public String alarmDescription() {
        return this.alarmDescription;
    }

    public Instant alarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public List<String> okActions() {
        return this.okActions;
    }

    public List<String> alarmActions() {
        return this.alarmActions;
    }

    public List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public String stateValue() {
        return this.stateValue;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String stateReasonData() {
        return this.stateReasonData;
    }

    public Instant stateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String statistic() {
        return this.statistic;
    }

    public String extendedStatistic() {
        return this.extendedStatistic;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Integer period() {
        return this.period;
    }

    public String unit() {
        return this.unit;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Double threshold() {
        return this.threshold;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public String treatMissingData() {
        return this.treatMissingData;
    }

    public String evaluateLowSampleCountPercentile() {
        return this.evaluateLowSampleCountPercentile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmName() == null ? 0 : this.alarmName().hashCode());
        hashCode = 31 * hashCode + (this.alarmArn() == null ? 0 : this.alarmArn().hashCode());
        hashCode = 31 * hashCode + (this.alarmDescription() == null ? 0 : this.alarmDescription().hashCode());
        hashCode = 31 * hashCode + (this.alarmConfigurationUpdatedTimestamp() == null ? 0 : this.alarmConfigurationUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.actionsEnabled() == null ? 0 : this.actionsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.okActions() == null ? 0 : this.okActions().hashCode());
        hashCode = 31 * hashCode + (this.alarmActions() == null ? 0 : this.alarmActions().hashCode());
        hashCode = 31 * hashCode + (this.insufficientDataActions() == null ? 0 : this.insufficientDataActions().hashCode());
        hashCode = 31 * hashCode + (this.stateValue() == null ? 0 : this.stateValue().hashCode());
        hashCode = 31 * hashCode + (this.stateReason() == null ? 0 : this.stateReason().hashCode());
        hashCode = 31 * hashCode + (this.stateReasonData() == null ? 0 : this.stateReasonData().hashCode());
        hashCode = 31 * hashCode + (this.stateUpdatedTimestamp() == null ? 0 : this.stateUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.statistic() == null ? 0 : this.statistic().hashCode());
        hashCode = 31 * hashCode + (this.extendedStatistic() == null ? 0 : this.extendedStatistic().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        hashCode = 31 * hashCode + (this.evaluationPeriods() == null ? 0 : this.evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.threshold() == null ? 0 : this.threshold().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.treatMissingData() == null ? 0 : this.treatMissingData().hashCode());
        hashCode = 31 * hashCode + (this.evaluateLowSampleCountPercentile() == null ? 0 : this.evaluateLowSampleCountPercentile().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAlarm)) {
            return false;
        }
        MetricAlarm other = (MetricAlarm)obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.alarmArn() == null ^ this.alarmArn() == null) {
            return false;
        }
        if (other.alarmArn() != null && !other.alarmArn().equals(this.alarmArn())) {
            return false;
        }
        if (other.alarmDescription() == null ^ this.alarmDescription() == null) {
            return false;
        }
        if (other.alarmDescription() != null && !other.alarmDescription().equals(this.alarmDescription())) {
            return false;
        }
        if (other.alarmConfigurationUpdatedTimestamp() == null ^ this.alarmConfigurationUpdatedTimestamp() == null) {
            return false;
        }
        if (other.alarmConfigurationUpdatedTimestamp() != null && !other.alarmConfigurationUpdatedTimestamp().equals(this.alarmConfigurationUpdatedTimestamp())) {
            return false;
        }
        if (other.actionsEnabled() == null ^ this.actionsEnabled() == null) {
            return false;
        }
        if (other.actionsEnabled() != null && !other.actionsEnabled().equals(this.actionsEnabled())) {
            return false;
        }
        if (other.okActions() == null ^ this.okActions() == null) {
            return false;
        }
        if (other.okActions() != null && !other.okActions().equals(this.okActions())) {
            return false;
        }
        if (other.alarmActions() == null ^ this.alarmActions() == null) {
            return false;
        }
        if (other.alarmActions() != null && !other.alarmActions().equals(this.alarmActions())) {
            return false;
        }
        if (other.insufficientDataActions() == null ^ this.insufficientDataActions() == null) {
            return false;
        }
        if (other.insufficientDataActions() != null && !other.insufficientDataActions().equals(this.insufficientDataActions())) {
            return false;
        }
        if (other.stateValue() == null ^ this.stateValue() == null) {
            return false;
        }
        if (other.stateValue() != null && !other.stateValue().equals(this.stateValue())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.stateReasonData() == null ^ this.stateReasonData() == null) {
            return false;
        }
        if (other.stateReasonData() != null && !other.stateReasonData().equals(this.stateReasonData())) {
            return false;
        }
        if (other.stateUpdatedTimestamp() == null ^ this.stateUpdatedTimestamp() == null) {
            return false;
        }
        if (other.stateUpdatedTimestamp() != null && !other.stateUpdatedTimestamp().equals(this.stateUpdatedTimestamp())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.extendedStatistic() == null ^ this.extendedStatistic() == null) {
            return false;
        }
        if (other.extendedStatistic() != null && !other.extendedStatistic().equals(this.extendedStatistic())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.treatMissingData() == null ^ this.treatMissingData() == null) {
            return false;
        }
        if (other.treatMissingData() != null && !other.treatMissingData().equals(this.treatMissingData())) {
            return false;
        }
        if (other.evaluateLowSampleCountPercentile() == null ^ this.evaluateLowSampleCountPercentile() == null) {
            return false;
        }
        return other.evaluateLowSampleCountPercentile() == null || other.evaluateLowSampleCountPercentile().equals(this.evaluateLowSampleCountPercentile());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.alarmArn() != null) {
            sb.append("AlarmArn: ").append(this.alarmArn()).append(",");
        }
        if (this.alarmDescription() != null) {
            sb.append("AlarmDescription: ").append(this.alarmDescription()).append(",");
        }
        if (this.alarmConfigurationUpdatedTimestamp() != null) {
            sb.append("AlarmConfigurationUpdatedTimestamp: ").append(this.alarmConfigurationUpdatedTimestamp()).append(",");
        }
        if (this.actionsEnabled() != null) {
            sb.append("ActionsEnabled: ").append(this.actionsEnabled()).append(",");
        }
        if (this.okActions() != null) {
            sb.append("OKActions: ").append(this.okActions()).append(",");
        }
        if (this.alarmActions() != null) {
            sb.append("AlarmActions: ").append(this.alarmActions()).append(",");
        }
        if (this.insufficientDataActions() != null) {
            sb.append("InsufficientDataActions: ").append(this.insufficientDataActions()).append(",");
        }
        if (this.stateValue() != null) {
            sb.append("StateValue: ").append(this.stateValue()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.stateReasonData() != null) {
            sb.append("StateReasonData: ").append(this.stateReasonData()).append(",");
        }
        if (this.stateUpdatedTimestamp() != null) {
            sb.append("StateUpdatedTimestamp: ").append(this.stateUpdatedTimestamp()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.statistic() != null) {
            sb.append("Statistic: ").append(this.statistic()).append(",");
        }
        if (this.extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(this.extendedStatistic()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        if (this.evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.evaluationPeriods()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        if (this.treatMissingData() != null) {
            sb.append("TreatMissingData: ").append(this.treatMissingData()).append(",");
        }
        if (this.evaluateLowSampleCountPercentile() != null) {
            sb.append("EvaluateLowSampleCountPercentile: ").append(this.evaluateLowSampleCountPercentile()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmArn;
        private String alarmDescription;
        private Instant alarmConfigurationUpdatedTimestamp;
        private Boolean actionsEnabled;
        private List<String> okActions;
        private List<String> alarmActions;
        private List<String> insufficientDataActions;
        private String stateValue;
        private String stateReason;
        private String stateReasonData;
        private Instant stateUpdatedTimestamp;
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions;
        private Integer period;
        private String unit;
        private Integer evaluationPeriods;
        private Double threshold;
        private String comparisonOperator;
        private String treatMissingData;
        private String evaluateLowSampleCountPercentile;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAlarm model) {
            this.setAlarmName(model.alarmName);
            this.setAlarmArn(model.alarmArn);
            this.setAlarmDescription(model.alarmDescription);
            this.setAlarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            this.setActionsEnabled(model.actionsEnabled);
            this.setOKActions(model.okActions);
            this.setAlarmActions(model.alarmActions);
            this.setInsufficientDataActions(model.insufficientDataActions);
            this.setStateValue(model.stateValue);
            this.setStateReason(model.stateReason);
            this.setStateReasonData(model.stateReasonData);
            this.setStateUpdatedTimestamp(model.stateUpdatedTimestamp);
            this.setMetricName(model.metricName);
            this.setNamespace(model.namespace);
            this.setStatistic(model.statistic);
            this.setExtendedStatistic(model.extendedStatistic);
            this.setDimensions(model.dimensions);
            this.setPeriod(model.period);
            this.setUnit(model.unit);
            this.setEvaluationPeriods(model.evaluationPeriods);
            this.setThreshold(model.threshold);
            this.setComparisonOperator(model.comparisonOperator);
            this.setTreatMissingData(model.treatMissingData);
            this.setEvaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmArn() {
            return this.alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final Instant getAlarmConfigurationUpdatedTimestamp() {
            return this.alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getOKActions() {
            return this.okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOKActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @SafeVarargs
        public final void setOKActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
        }

        public final Collection<String> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @SafeVarargs
        public final void setAlarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
        }

        public final Collection<String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @SafeVarargs
        public final void setInsufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final void setStateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return this.stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        public final Instant getStateUpdatedTimestamp() {
            return this.stateUpdatedTimestamp;
        }

        @Override
        public final Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
            return this;
        }

        public final void setStateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final void setStatistic(Statistic statistic) {
            this.statistic(statistic.toString());
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @SafeVarargs
        public final void setDimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(StandardUnit unit) {
            this.unit(unit.toString());
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final void setComparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        public MetricAlarm build() {
            return new MetricAlarm(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricAlarm> {
        public Builder alarmName(String var1);

        public Builder alarmArn(String var1);

        public Builder alarmDescription(String var1);

        public Builder alarmConfigurationUpdatedTimestamp(Instant var1);

        public Builder actionsEnabled(Boolean var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder stateReason(String var1);

        public Builder stateReasonData(String var1);

        public Builder stateUpdatedTimestamp(Instant var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder treatMissingData(String var1);

        public Builder evaluateLowSampleCountPercentile(String var1);
    }
}

