/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarmsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmsForMetricResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
    private final List<MetricAlarm> metricAlarms;

    private DescribeAlarmsForMetricResponse(BuilderImpl builder) {
        this.metricAlarms = builder.metricAlarms;
    }

    public List<MetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricAlarms() == null ? 0 : this.metricAlarms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricResponse)) {
            return false;
        }
        DescribeAlarmsForMetricResponse other = (DescribeAlarmsForMetricResponse)((Object)obj);
        if (other.metricAlarms() == null ^ this.metricAlarms() == null) {
            return false;
        }
        return other.metricAlarms() == null || other.metricAlarms().equals(this.metricAlarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricAlarms() != null) {
            sb.append("MetricAlarms: ").append(this.metricAlarms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MetricAlarm> metricAlarms;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricResponse model) {
            this.setMetricAlarms(model.metricAlarms);
        }

        public final Collection<MetricAlarm> getMetricAlarms() {
            return this.metricAlarms;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
        }

        @SafeVarargs
        public final void setMetricAlarms(MetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
        }

        public DescribeAlarmsForMetricResponse build() {
            return new DescribeAlarmsForMetricResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
        public Builder metricAlarms(Collection<MetricAlarm> var1);

        public Builder metricAlarms(MetricAlarm ... var1);
    }
}

