/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataAsyncClient;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataAsyncClientBuilder;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtraildata.DefaultCloudTrailDataAsyncClient;
import software.amazon.awssdk.services.cloudtraildata.DefaultCloudTrailDataBaseClientBuilder;
import software.amazon.awssdk.services.cloudtraildata.endpoints.CloudTrailDataEndpointProvider;

@SdkInternalApi
final class DefaultCloudTrailDataAsyncClientBuilder
extends DefaultCloudTrailDataBaseClientBuilder<CloudTrailDataAsyncClientBuilder, CloudTrailDataAsyncClient>
implements CloudTrailDataAsyncClientBuilder {
    DefaultCloudTrailDataAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudTrailDataAsyncClientBuilder endpointProvider(CloudTrailDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudTrailDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudTrailDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudTrailDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudTrailDataAsyncClient client = new DefaultCloudTrailDataAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudTrailDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudTrailDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

