/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.ImportFailureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportFailureListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportFailureListItem> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(ImportFailureListItem.getter(ImportFailureListItem::location)).setter(ImportFailureListItem.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ImportFailureListItem.getter(ImportFailureListItem::statusAsString)).setter(ImportFailureListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorType").getter(ImportFailureListItem.getter(ImportFailureListItem::errorType)).setter(ImportFailureListItem.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorType").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ImportFailureListItem.getter(ImportFailureListItem::errorMessage)).setter(ImportFailureListItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ImportFailureListItem.getter(ImportFailureListItem::lastUpdatedTime)).setter(ImportFailureListItem.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, STATUS_FIELD, ERROR_TYPE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String location;
    private final String status;
    private final String errorType;
    private final String errorMessage;
    private final Instant lastUpdatedTime;

    private ImportFailureListItem(BuilderImpl builder) {
        this.location = builder.location;
        this.status = builder.status;
        this.errorType = builder.errorType;
        this.errorMessage = builder.errorMessage;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String location() {
        return this.location;
    }

    public final ImportFailureStatus status() {
        return ImportFailureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorType() {
        return this.errorType;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportFailureListItem)) {
            return false;
        }
        ImportFailureListItem other = (ImportFailureListItem)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorType(), other.errorType()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImportFailureListItem").add("Location", (Object)this.location()).add("Status", (Object)this.statusAsString()).add("ErrorType", (Object)this.errorType()).add("ErrorMessage", (Object)this.errorMessage()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorType": {
                return Optional.ofNullable(clazz.cast(this.errorType()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportFailureListItem, T> g) {
        return obj -> g.apply((ImportFailureListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String status;
        private String errorType;
        private String errorMessage;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportFailureListItem model) {
            this.location(model.location);
            this.status(model.status);
            this.errorType(model.errorType);
            this.errorMessage(model.errorMessage);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportFailureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public ImportFailureListItem build() {
            return new ImportFailureListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportFailureListItem> {
        public Builder location(String var1);

        public Builder status(String var1);

        public Builder status(ImportFailureStatus var1);

        public Builder errorType(String var1);

        public Builder errorMessage(String var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

