/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.ImportFailureListItem;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;

public class ListImportFailuresIterable
implements SdkIterable<ListImportFailuresResponse> {
    private final CloudTrailClient client;
    private final ListImportFailuresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportFailuresIterable(CloudTrailClient client, ListImportFailuresRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImportFailuresResponseFetcher();
    }

    public Iterator<ListImportFailuresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportFailureListItem> failures() {
        Function<ListImportFailuresResponse, Iterator> getIterator = response -> {
            if (response != null && response.failures() != null) {
                return response.failures().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportFailuresResponseFetcher
    implements SyncPageFetcher<ListImportFailuresResponse> {
        private ListImportFailuresResponseFetcher() {
        }

        public boolean hasNextPage(ListImportFailuresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportFailuresResponse nextPage(ListImportFailuresResponse previousPage) {
            if (previousPage == null) {
                return ListImportFailuresIterable.this.client.listImportFailures(ListImportFailuresIterable.this.firstRequest);
            }
            return ListImportFailuresIterable.this.client.listImportFailures((ListImportFailuresRequest)((Object)ListImportFailuresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

