/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportFailureStatus {
    FAILED("FAILED"),
    RETRY("RETRY"),
    SUCCEEDED("SUCCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportFailureStatus> VALUE_MAP;
    private final String value;

    private ImportFailureStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportFailureStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportFailureStatus> knownValues() {
        EnumSet<ImportFailureStatus> knownValues = EnumSet.allOf(ImportFailureStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportFailureStatus.class, ImportFailureStatus::toString);
    }
}

