/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrailRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, UpdateTrailRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateTrailRequest.getter(UpdateTrailRequest::name)).setter(UpdateTrailRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(UpdateTrailRequest.getter(UpdateTrailRequest::s3BucketName)).setter(UpdateTrailRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(UpdateTrailRequest.getter(UpdateTrailRequest::s3KeyPrefix)).setter(UpdateTrailRequest.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicName").getter(UpdateTrailRequest.getter(UpdateTrailRequest::snsTopicName)).setter(UpdateTrailRequest.setter(Builder::snsTopicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeGlobalServiceEvents").getter(UpdateTrailRequest.getter(UpdateTrailRequest::includeGlobalServiceEvents)).setter(UpdateTrailRequest.setter(Builder::includeGlobalServiceEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build()}).build();
    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsMultiRegionTrail").getter(UpdateTrailRequest.getter(UpdateTrailRequest::isMultiRegionTrail)).setter(UpdateTrailRequest.setter(Builder::isMultiRegionTrail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build()}).build();
    private static final SdkField<Boolean> ENABLE_LOG_FILE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableLogFileValidation").getter(UpdateTrailRequest.getter(UpdateTrailRequest::enableLogFileValidation)).setter(UpdateTrailRequest.setter(Builder::enableLogFileValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLogFileValidation").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn").getter(UpdateTrailRequest.getter(UpdateTrailRequest::cloudWatchLogsLogGroupArn)).setter(UpdateTrailRequest.setter(Builder::cloudWatchLogsLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogsRoleArn").getter(UpdateTrailRequest.getter(UpdateTrailRequest::cloudWatchLogsRoleArn)).setter(UpdateTrailRequest.setter(Builder::cloudWatchLogsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(UpdateTrailRequest.getter(UpdateTrailRequest::kmsKeyId)).setter(UpdateTrailRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsOrganizationTrail").getter(UpdateTrailRequest.getter(UpdateTrailRequest::isOrganizationTrail)).setter(UpdateTrailRequest.setter(Builder::isOrganizationTrail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, SNS_TOPIC_NAME_FIELD, INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD, IS_MULTI_REGION_TRAIL_FIELD, ENABLE_LOG_FILE_VALIDATION_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, IS_ORGANIZATION_TRAIL_FIELD));
    private final String name;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String snsTopicName;
    private final Boolean includeGlobalServiceEvents;
    private final Boolean isMultiRegionTrail;
    private final Boolean enableLogFileValidation;
    private final String cloudWatchLogsLogGroupArn;
    private final String cloudWatchLogsRoleArn;
    private final String kmsKeyId;
    private final Boolean isOrganizationTrail;

    private UpdateTrailRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicName = builder.snsTopicName;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.enableLogFileValidation = builder.enableLogFileValidation;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.isOrganizationTrail = builder.isOrganizationTrail;
    }

    public final String name() {
        return this.name;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final String snsTopicName() {
        return this.snsTopicName;
    }

    public final Boolean includeGlobalServiceEvents() {
        return this.includeGlobalServiceEvents;
    }

    public final Boolean isMultiRegionTrail() {
        return this.isMultiRegionTrail;
    }

    public final Boolean enableLogFileValidation() {
        return this.enableLogFileValidation;
    }

    public final String cloudWatchLogsLogGroupArn() {
        return this.cloudWatchLogsLogGroupArn;
    }

    public final String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean isOrganizationTrail() {
        return this.isOrganizationTrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLogFileValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOrganizationTrail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrailRequest)) {
            return false;
        }
        UpdateTrailRequest other = (UpdateTrailRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.snsTopicName(), other.snsTopicName()) && Objects.equals(this.includeGlobalServiceEvents(), other.includeGlobalServiceEvents()) && Objects.equals(this.isMultiRegionTrail(), other.isMultiRegionTrail()) && Objects.equals(this.enableLogFileValidation(), other.enableLogFileValidation()) && Objects.equals(this.cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.isOrganizationTrail(), other.isOrganizationTrail());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrailRequest").add("Name", (Object)this.name()).add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("SnsTopicName", (Object)this.snsTopicName()).add("IncludeGlobalServiceEvents", (Object)this.includeGlobalServiceEvents()).add("IsMultiRegionTrail", (Object)this.isMultiRegionTrail()).add("EnableLogFileValidation", (Object)this.enableLogFileValidation()).add("CloudWatchLogsLogGroupArn", (Object)this.cloudWatchLogsLogGroupArn()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("IsOrganizationTrail", (Object)this.isOrganizationTrail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "SnsTopicName": {
                return Optional.ofNullable(clazz.cast(this.snsTopicName()));
            }
            case "IncludeGlobalServiceEvents": {
                return Optional.ofNullable(clazz.cast(this.includeGlobalServiceEvents()));
            }
            case "IsMultiRegionTrail": {
                return Optional.ofNullable(clazz.cast(this.isMultiRegionTrail()));
            }
            case "EnableLogFileValidation": {
                return Optional.ofNullable(clazz.cast(this.enableLogFileValidation()));
            }
            case "CloudWatchLogsLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsLogGroupArn()));
            }
            case "CloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "IsOrganizationTrail": {
                return Optional.ofNullable(clazz.cast(this.isOrganizationTrail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrailRequest, T> g) {
        return obj -> g.apply((UpdateTrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String name;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String snsTopicName;
        private Boolean includeGlobalServiceEvents;
        private Boolean isMultiRegionTrail;
        private Boolean enableLogFileValidation;
        private String cloudWatchLogsLogGroupArn;
        private String cloudWatchLogsRoleArn;
        private String kmsKeyId;
        private Boolean isOrganizationTrail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrailRequest model) {
            super(model);
            this.name(model.name);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.snsTopicName(model.snsTopicName);
            this.includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            this.isMultiRegionTrail(model.isMultiRegionTrail);
            this.enableLogFileValidation(model.enableLogFileValidation);
            this.cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.isOrganizationTrail(model.isOrganizationTrail);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        @Transient
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getSnsTopicName() {
            return this.snsTopicName;
        }

        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        @Override
        @Transient
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return this.includeGlobalServiceEvents;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        @Override
        @Transient
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final Boolean getIsMultiRegionTrail() {
            return this.isMultiRegionTrail;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        @Override
        @Transient
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final Boolean getEnableLogFileValidation() {
            return this.enableLogFileValidation;
        }

        public final void setEnableLogFileValidation(Boolean enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
        }

        @Override
        @Transient
        public final Builder enableLogFileValidation(Boolean enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
            return this;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getIsOrganizationTrail() {
            return this.isOrganizationTrail;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        @Override
        @Transient
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrailRequest build() {
            return new UpdateTrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrailRequest> {
        public Builder name(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder snsTopicName(String var1);

        public Builder includeGlobalServiceEvents(Boolean var1);

        public Builder isMultiRegionTrail(Boolean var1);

        public Builder enableLogFileValidation(Boolean var1);

        public Builder cloudWatchLogsLogGroupArn(String var1);

        public Builder cloudWatchLogsRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder isOrganizationTrail(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

