/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.EventsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookupEventsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, LookupEventsResponse> {
    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(LookupEventsResponse.getter(LookupEventsResponse::events)).setter(LookupEventsResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(LookupEventsResponse.getter(LookupEventsResponse::nextToken)).setter(LookupEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Event> events;
    private final String nextToken;

    private LookupEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<Event> events() {
        return this.events;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsResponse)) {
            return false;
        }
        LookupEventsResponse other = (LookupEventsResponse)((Object)obj);
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"LookupEventsResponse").add("Events", this.hasEvents() ? this.events() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupEventsResponse, T> g) {
        return obj -> g.apply((LookupEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupEventsResponse model) {
            super(model);
            this.events(model.events);
            this.nextToken(model.nextToken);
        }

        public final List<Event.Builder> getEvents() {
            List<Event.Builder> result = EventsListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventsListCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<Event> events) {
            this.events = EventsListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (Event)((Event.Builder)Event.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public LookupEventsResponse build() {
            return new LookupEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LookupEventsResponse> {
        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder events(Consumer<Event.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

