/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRequest
extends CloudSearchDomainRequest
implements ToCopyableBuilder<Builder, SearchRequest> {
    private static final SdkField<String> CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cursor").getter(SearchRequest.getter(SearchRequest::cursor)).setter(SearchRequest.setter(Builder::cursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("cursor").build()}).build();
    private static final SdkField<String> EXPR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expr").getter(SearchRequest.getter(SearchRequest::expr)).setter(SearchRequest.setter(Builder::expr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expr").build()}).build();
    private static final SdkField<String> FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("facet").getter(SearchRequest.getter(SearchRequest::facet)).setter(SearchRequest.setter(Builder::facet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("facet").build()}).build();
    private static final SdkField<String> FILTER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterQuery").getter(SearchRequest.getter(SearchRequest::filterQuery)).setter(SearchRequest.setter(Builder::filterQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fq").build()}).build();
    private static final SdkField<String> HIGHLIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("highlight").getter(SearchRequest.getter(SearchRequest::highlight)).setter(SearchRequest.setter(Builder::highlight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("highlight").build()}).build();
    private static final SdkField<Boolean> PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("partial").getter(SearchRequest.getter(SearchRequest::partial)).setter(SearchRequest.setter(Builder::partial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partial").build()}).build();
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("query").getter(SearchRequest.getter(SearchRequest::query)).setter(SearchRequest.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("q").build()}).build();
    private static final SdkField<String> QUERY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryOptions").getter(SearchRequest.getter(SearchRequest::queryOptions)).setter(SearchRequest.setter(Builder::queryOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("q.options").build()}).build();
    private static final SdkField<String> QUERY_PARSER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryParser").getter(SearchRequest.getter(SearchRequest::queryParserAsString)).setter(SearchRequest.setter(Builder::queryParser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("q.parser").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(SearchRequest.getter(SearchRequest::size)).setter(SearchRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("size").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sort").getter(SearchRequest.getter(SearchRequest::sort)).setter(SearchRequest.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sort").build()}).build();
    private static final SdkField<Long> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("start").getter(SearchRequest.getter(SearchRequest::start)).setter(SearchRequest.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("start").build()}).build();
    private static final SdkField<String> STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stats").getter(SearchRequest.getter(SearchRequest::stats)).setter(SearchRequest.setter(Builder::stats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stats").build()}).build();
    private static final SdkField<String> RETURN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("returnValues").getter(SearchRequest.getter(SearchRequest::returnValues)).setter(SearchRequest.setter(Builder::returnValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("return").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURSOR_FIELD, EXPR_FIELD, FACET_FIELD, FILTER_QUERY_FIELD, HIGHLIGHT_FIELD, PARTIAL_FIELD, QUERY_FIELD, QUERY_OPTIONS_FIELD, QUERY_PARSER_FIELD, SIZE_FIELD, SORT_FIELD, START_FIELD, STATS_FIELD, RETURN_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchRequest.memberNameToFieldInitializer();
    private final String cursor;
    private final String expr;
    private final String facet;
    private final String filterQuery;
    private final String highlight;
    private final Boolean partial;
    private final String query;
    private final String queryOptions;
    private final String queryParser;
    private final Long size;
    private final String sort;
    private final Long start;
    private final String stats;
    private final String returnValues;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.cursor = builder.cursor;
        this.expr = builder.expr;
        this.facet = builder.facet;
        this.filterQuery = builder.filterQuery;
        this.highlight = builder.highlight;
        this.partial = builder.partial;
        this.query = builder.query;
        this.queryOptions = builder.queryOptions;
        this.queryParser = builder.queryParser;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
        this.stats = builder.stats;
        this.returnValues = builder.returnValues;
    }

    public final String cursor() {
        return this.cursor;
    }

    public final String expr() {
        return this.expr;
    }

    public final String facet() {
        return this.facet;
    }

    public final String filterQuery() {
        return this.filterQuery;
    }

    public final String highlight() {
        return this.highlight;
    }

    public final Boolean partial() {
        return this.partial;
    }

    public final String query() {
        return this.query;
    }

    public final String queryOptions() {
        return this.queryOptions;
    }

    public final QueryParser queryParser() {
        return QueryParser.fromValue(this.queryParser);
    }

    public final String queryParserAsString() {
        return this.queryParser;
    }

    public final Long size() {
        return this.size;
    }

    public final String sort() {
        return this.sort;
    }

    public final Long start() {
        return this.start;
    }

    public final String stats() {
        return this.stats;
    }

    public final String returnValues() {
        return this.returnValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.expr());
        hashCode = 31 * hashCode + Objects.hashCode(this.facet());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlight());
        hashCode = 31 * hashCode + Objects.hashCode(this.partial());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryParserAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stats());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest)((Object)obj);
        return Objects.equals(this.cursor(), other.cursor()) && Objects.equals(this.expr(), other.expr()) && Objects.equals(this.facet(), other.facet()) && Objects.equals(this.filterQuery(), other.filterQuery()) && Objects.equals(this.highlight(), other.highlight()) && Objects.equals(this.partial(), other.partial()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.queryOptions(), other.queryOptions()) && Objects.equals(this.queryParserAsString(), other.queryParserAsString()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stats(), other.stats()) && Objects.equals(this.returnValues(), other.returnValues());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRequest").add("Cursor", (Object)this.cursor()).add("Expr", (Object)this.expr()).add("Facet", (Object)this.facet()).add("FilterQuery", (Object)this.filterQuery()).add("Highlight", (Object)this.highlight()).add("Partial", (Object)this.partial()).add("Query", (Object)this.query()).add("QueryOptions", (Object)this.queryOptions()).add("QueryParser", (Object)this.queryParserAsString()).add("Size", (Object)this.size()).add("Sort", (Object)this.sort()).add("Start", (Object)this.start()).add("Stats", (Object)this.stats()).add("ReturnValues", (Object)this.returnValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cursor": {
                return Optional.ofNullable(clazz.cast(this.cursor()));
            }
            case "expr": {
                return Optional.ofNullable(clazz.cast(this.expr()));
            }
            case "facet": {
                return Optional.ofNullable(clazz.cast(this.facet()));
            }
            case "filterQuery": {
                return Optional.ofNullable(clazz.cast(this.filterQuery()));
            }
            case "highlight": {
                return Optional.ofNullable(clazz.cast(this.highlight()));
            }
            case "partial": {
                return Optional.ofNullable(clazz.cast(this.partial()));
            }
            case "query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "queryOptions": {
                return Optional.ofNullable(clazz.cast(this.queryOptions()));
            }
            case "queryParser": {
                return Optional.ofNullable(clazz.cast(this.queryParserAsString()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "stats": {
                return Optional.ofNullable(clazz.cast(this.stats()));
            }
            case "returnValues": {
                return Optional.ofNullable(clazz.cast(this.returnValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cursor", CURSOR_FIELD);
        map.put("expr", EXPR_FIELD);
        map.put("facet", FACET_FIELD);
        map.put("fq", FILTER_QUERY_FIELD);
        map.put("highlight", HIGHLIGHT_FIELD);
        map.put("partial", PARTIAL_FIELD);
        map.put("q", QUERY_FIELD);
        map.put("q.options", QUERY_OPTIONS_FIELD);
        map.put("q.parser", QUERY_PARSER_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("start", START_FIELD);
        map.put("stats", STATS_FIELD);
        map.put("return", RETURN_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRequest, T> g) {
        return obj -> g.apply((SearchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchDomainRequest.BuilderImpl
    implements Builder {
        private String cursor;
        private String expr;
        private String facet;
        private String filterQuery;
        private String highlight;
        private Boolean partial;
        private String query;
        private String queryOptions;
        private String queryParser;
        private Long size;
        private String sort;
        private Long start;
        private String stats;
        private String returnValues;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            super(model);
            this.cursor(model.cursor);
            this.expr(model.expr);
            this.facet(model.facet);
            this.filterQuery(model.filterQuery);
            this.highlight(model.highlight);
            this.partial(model.partial);
            this.query(model.query);
            this.queryOptions(model.queryOptions);
            this.queryParser(model.queryParser);
            this.size(model.size);
            this.sort(model.sort);
            this.start(model.start);
            this.stats(model.stats);
            this.returnValues(model.returnValues);
        }

        public final String getCursor() {
            return this.cursor;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final String getExpr() {
            return this.expr;
        }

        public final void setExpr(String expr) {
            this.expr = expr;
        }

        @Override
        public final Builder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public final String getFacet() {
            return this.facet;
        }

        public final void setFacet(String facet) {
            this.facet = facet;
        }

        @Override
        public final Builder facet(String facet) {
            this.facet = facet;
            return this;
        }

        public final String getFilterQuery() {
            return this.filterQuery;
        }

        public final void setFilterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
        }

        @Override
        public final Builder filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public final String getHighlight() {
            return this.highlight;
        }

        public final void setHighlight(String highlight) {
            this.highlight = highlight;
        }

        @Override
        public final Builder highlight(String highlight) {
            this.highlight = highlight;
            return this;
        }

        public final Boolean getPartial() {
            return this.partial;
        }

        public final void setPartial(Boolean partial) {
            this.partial = partial;
        }

        @Override
        public final Builder partial(Boolean partial) {
            this.partial = partial;
            return this;
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getQueryOptions() {
            return this.queryOptions;
        }

        public final void setQueryOptions(String queryOptions) {
            this.queryOptions = queryOptions;
        }

        @Override
        public final Builder queryOptions(String queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public final String getQueryParser() {
            return this.queryParser;
        }

        public final void setQueryParser(String queryParser) {
            this.queryParser = queryParser;
        }

        @Override
        public final Builder queryParser(String queryParser) {
            this.queryParser = queryParser;
            return this;
        }

        @Override
        public final Builder queryParser(QueryParser queryParser) {
            this.queryParser(queryParser == null ? null : queryParser.toString());
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final String getSort() {
            return this.sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public final Long getStart() {
            return this.start;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final String getStats() {
            return this.stats;
        }

        public final void setStats(String stats) {
            this.stats = stats;
        }

        @Override
        public final Builder stats(String stats) {
            this.stats = stats;
            return this;
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudSearchDomainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRequest> {
        public Builder cursor(String var1);

        public Builder expr(String var1);

        public Builder facet(String var1);

        public Builder filterQuery(String var1);

        public Builder highlight(String var1);

        public Builder partial(Boolean var1);

        public Builder query(String var1);

        public Builder queryOptions(String var1);

        public Builder queryParser(String var1);

        public Builder queryParser(QueryParser var1);

        public Builder size(Long var1);

        public Builder sort(String var1);

        public Builder start(Long var1);

        public Builder stats(String var1);

        public Builder returnValues(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

