/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.endpoints.internal;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.services.cloudsearchdomain.endpoints.internal.Outputs;

@SdkInternalApi
public class RulePartition {
    private static final String DNS_SUFFIX = "dnsSuffix";
    private static final String DUAL_STACK_DNS_SUFFIX = "dualStackDnsSuffix";
    private static final String SUPPORTS_FIPS = "supportsFIPS";
    private static final String SUPPORTS_DUAL_STACK = "supportsDualStack";
    private final String name;
    private final String dnsSuffix;
    private final String dualStackDnsSuffix;
    private final boolean supportsFips;
    private final boolean supportsDualStack;

    private RulePartition(Builder builder) {
        this.name = builder.name;
        this.dnsSuffix = builder.dnsSuffix;
        this.dualStackDnsSuffix = builder.dualStackDnsSuffix;
        this.supportsFips = builder.supportsFips;
        this.supportsDualStack = builder.supportsDualStack;
    }

    public String name() {
        return this.name;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public String dualStackDnsSuffix() {
        return this.dualStackDnsSuffix;
    }

    public boolean supportsFips() {
        return this.supportsFips;
    }

    public boolean supportsFIPS() {
        return this.supportsFips;
    }

    public boolean supportsDualStack() {
        return this.supportsDualStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RulePartition that = (RulePartition)o;
        return this.supportsFips == that.supportsFips && this.supportsDualStack == that.supportsDualStack && Objects.equals(this.name, that.name) && Objects.equals(this.dnsSuffix, that.dnsSuffix) && Objects.equals(this.dualStackDnsSuffix, that.dualStackDnsSuffix);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dnsSuffix, this.dualStackDnsSuffix, this.supportsFips, this.supportsDualStack);
    }

    public static Builder builder() {
        return new Builder();
    }

    static RulePartition from(String name, Outputs outputs) {
        return RulePartition.builder().name(name).dnsSuffix(outputs.dnsSuffix()).dualStackDnsSuffix(outputs.dualStackDnsSuffix()).supportsFips(outputs.supportsFips()).supportsDualStack(outputs.supportsDualStack()).build();
    }

    public static RulePartition fromNode(String name, JsonNode node) {
        JsonNode supportsDualStack;
        JsonNode supportsFips;
        JsonNode dualStackDnsSuffix;
        Map objNode = node.asObject();
        Builder b = RulePartition.builder();
        b.name(name);
        JsonNode dnsSuffix = (JsonNode)objNode.get(DNS_SUFFIX);
        if (dnsSuffix != null) {
            b.dnsSuffix(dnsSuffix.asString());
        }
        if ((dualStackDnsSuffix = (JsonNode)objNode.get(DUAL_STACK_DNS_SUFFIX)) != null) {
            b.dualStackDnsSuffix(dualStackDnsSuffix.asString());
        }
        if ((supportsFips = (JsonNode)objNode.get(SUPPORTS_FIPS)) != null) {
            b.supportsFips(supportsFips.asBoolean());
        }
        if ((supportsDualStack = (JsonNode)objNode.get(SUPPORTS_DUAL_STACK)) != null) {
            b.supportsDualStack(supportsDualStack.asBoolean());
        }
        return b.build();
    }

    public static class Builder {
        private String name;
        private String dnsSuffix;
        private String dualStackDnsSuffix;
        private boolean supportsFips;
        private boolean supportsDualStack;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dnsSuffix(String dnsSuffix) {
            this.dnsSuffix = dnsSuffix;
            return this;
        }

        public Builder dualStackDnsSuffix(String dualStackDnsSuffix) {
            this.dualStackDnsSuffix = dualStackDnsSuffix;
            return this;
        }

        public Builder supportsFips(boolean supportsFips) {
            this.supportsFips = supportsFips;
            return this;
        }

        public Builder supportsDualStack(boolean supportsDualStack) {
            this.supportsDualStack = supportsDualStack;
            return this;
        }

        public RulePartition build() {
            return new RulePartition(this);
        }
    }
}

