/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestRequest
extends CloudSearchDomainRequest
implements ToCopyableBuilder<Builder, SuggestRequest> {
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("query").getter(SuggestRequest.getter(SuggestRequest::query)).setter(SuggestRequest.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("q").build()}).build();
    private static final SdkField<String> SUGGESTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suggester").getter(SuggestRequest.getter(SuggestRequest::suggester)).setter(SuggestRequest.setter(Builder::suggester)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("suggester").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(SuggestRequest.getter(SuggestRequest::size)).setter(SuggestRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, SUGGESTER_FIELD, SIZE_FIELD));
    private final String query;
    private final String suggester;
    private final Long size;

    private SuggestRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.suggester = builder.suggester;
        this.size = builder.size;
    }

    public final String query() {
        return this.query;
    }

    public final String suggester() {
        return this.suggester;
    }

    public final Long size() {
        return this.size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggester());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestRequest)) {
            return false;
        }
        SuggestRequest other = (SuggestRequest)((Object)obj);
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.suggester(), other.suggester()) && Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestRequest").add("Query", (Object)this.query()).add("Suggester", (Object)this.suggester()).add("Size", (Object)this.size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "suggester": {
                return Optional.ofNullable(clazz.cast(this.suggester()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestRequest, T> g) {
        return obj -> g.apply((SuggestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchDomainRequest.BuilderImpl
    implements Builder {
        private String query;
        private String suggester;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestRequest model) {
            super(model);
            this.query(model.query);
            this.suggester(model.suggester);
            this.size(model.size);
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        @Transient
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getSuggester() {
            return this.suggester;
        }

        public final void setSuggester(String suggester) {
            this.suggester = suggester;
        }

        @Override
        @Transient
        public final Builder suggester(String suggester) {
            this.suggester = suggester;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        @Transient
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuggestRequest build() {
            return new SuggestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchDomainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuggestRequest> {
        public Builder query(String var1);

        public Builder suggester(String var1);

        public Builder size(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

