/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.FacetsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hits;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus;
import software.amazon.awssdk.services.cloudsearchdomain.model.StatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, SearchResponse> {
    private static final SdkField<SearchStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(SearchResponse.getter(SearchResponse::status)).setter(SearchResponse.setter(Builder::status)).constructor(SearchStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Hits> HITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hits").getter(SearchResponse.getter(SearchResponse::hits)).setter(SearchResponse.setter(Builder::hits)).constructor(Hits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hits").build()}).build();
    private static final SdkField<Map<String, BucketInfo>> FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("facets").getter(SearchResponse.getter(SearchResponse::facets)).setter(SearchResponse.setter(Builder::facets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("facets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BucketInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FieldStats>> STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stats").getter(SearchResponse.getter(SearchResponse::stats)).setter(SearchResponse.setter(Builder::stats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stats").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, HITS_FIELD, FACETS_FIELD, STATS_FIELD));
    private final SearchStatus status;
    private final Hits hits;
    private final Map<String, BucketInfo> facets;
    private final Map<String, FieldStats> stats;

    private SearchResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.hits = builder.hits;
        this.facets = builder.facets;
        this.stats = builder.stats;
    }

    public final SearchStatus status() {
        return this.status;
    }

    public final Hits hits() {
        return this.hits;
    }

    public final boolean hasFacets() {
        return this.facets != null && !(this.facets instanceof SdkAutoConstructMap);
    }

    public final Map<String, BucketInfo> facets() {
        return this.facets;
    }

    public final boolean hasStats() {
        return this.stats != null && !(this.stats instanceof SdkAutoConstructMap);
    }

    public final Map<String, FieldStats> stats() {
        return this.stats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacets() ? this.facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStats() ? this.stats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.hits(), other.hits()) && this.hasFacets() == other.hasFacets() && Objects.equals(this.facets(), other.facets()) && this.hasStats() == other.hasStats() && Objects.equals(this.stats(), other.stats());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResponse").add("Status", (Object)this.status()).add("Hits", (Object)this.hits()).add("Facets", this.hasFacets() ? this.facets() : null).add("Stats", this.hasStats() ? this.stats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "hits": {
                return Optional.ofNullable(clazz.cast(this.hits()));
            }
            case "facets": {
                return Optional.ofNullable(clazz.cast(this.facets()));
            }
            case "stats": {
                return Optional.ofNullable(clazz.cast(this.stats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResponse, T> g) {
        return obj -> g.apply((SearchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private SearchStatus status;
        private Hits hits;
        private Map<String, BucketInfo> facets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, FieldStats> stats = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResponse model) {
            super(model);
            this.status(model.status);
            this.hits(model.hits);
            this.facets(model.facets);
            this.stats(model.stats);
        }

        public final SearchStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Hits.Builder getHits() {
            return this.hits != null ? this.hits.toBuilder() : null;
        }

        @Override
        public final Builder hits(Hits hits) {
            this.hits = hits;
            return this;
        }

        public final void setHits(Hits.BuilderImpl hits) {
            this.hits = hits != null ? hits.build() : null;
        }

        public final Map<String, BucketInfo.Builder> getFacets() {
            Map<String, BucketInfo.Builder> result = FacetsCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder facets(Map<String, BucketInfo> facets) {
            this.facets = FacetsCopier.copy(facets);
            return this;
        }

        public final void setFacets(Map<String, BucketInfo.BuilderImpl> facets) {
            this.facets = FacetsCopier.copyFromBuilder(facets);
        }

        public final Map<String, FieldStats.Builder> getStats() {
            Map<String, FieldStats.Builder> result = StatsCopier.copyToBuilder(this.stats);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stats(Map<String, FieldStats> stats) {
            this.stats = StatsCopier.copy(stats);
            return this;
        }

        public final void setStats(Map<String, FieldStats.BuilderImpl> stats) {
            this.stats = StatsCopier.copyFromBuilder(stats);
        }

        @Override
        public SearchResponse build() {
            return new SearchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchResponse> {
        public Builder status(SearchStatus var1);

        default public Builder status(Consumer<SearchStatus.Builder> status) {
            return this.status((SearchStatus)((SearchStatus.Builder)SearchStatus.builder().applyMutation(status)).build());
        }

        public Builder hits(Hits var1);

        default public Builder hits(Consumer<Hits.Builder> hits) {
            return this.hits((Hits)((Hits.Builder)Hits.builder().applyMutation(hits)).build());
        }

        public Builder facets(Map<String, BucketInfo> var1);

        public Builder stats(Map<String, FieldStats> var1);
    }
}

