/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearchdomain.model.Bucket;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketInfo> {
    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buckets").getter(BucketInfo.getter(BucketInfo::buckets)).setter(BucketInfo.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Bucket> buckets;

    private BucketInfo(BuilderImpl builder) {
        this.buckets = builder.buckets;
    }

    public final boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public final List<Bucket> buckets() {
        return this.buckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo other = (BucketInfo)obj;
        return this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets());
    }

    public final String toString() {
        return ToString.builder((String)"BucketInfo").add("Buckets", this.hasBuckets() ? this.buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketInfo, T> g) {
        return obj -> g.apply((BucketInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BucketInfo model) {
            this.buckets(model.buckets);
        }

        public final Collection<Bucket.Builder> getBuckets() {
            if (this.buckets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buckets != null ? (Collection)this.buckets.stream().map(Bucket::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder> ... buckets) {
            this.buckets(Stream.of(buckets).map(c -> (Bucket)((Bucket.Builder)Bucket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketListCopier.copyFromBuilder(buckets);
        }

        public BucketInfo build() {
            return new BucketInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketInfo> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);

        public Builder buckets(Consumer<Bucket.Builder> ... var1);
    }
}

