/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainAsyncClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.DefaultCloudSearchDomainAsyncClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse;

public interface CloudSearchDomainAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "cloudsearch";
    public static final String SERVICE_METADATA_ID = "cloudsearchdomain";

    public static CloudSearchDomainAsyncClient create() {
        return (CloudSearchDomainAsyncClient)CloudSearchDomainAsyncClient.builder().build();
    }

    public static CloudSearchDomainAsyncClientBuilder builder() {
        return new DefaultCloudSearchDomainAsyncClientBuilder();
    }

    default public CompletableFuture<SearchResponse> search(SearchRequest searchRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchResponse> search(Consumer<SearchRequest.Builder> searchRequest) {
        return this.search((SearchRequest)((Object)((SearchRequest.Builder)SearchRequest.builder().applyMutation(searchRequest)).build()));
    }

    default public CompletableFuture<SuggestResponse> suggest(SuggestRequest suggestRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SuggestResponse> suggest(Consumer<SuggestRequest.Builder> suggestRequest) {
        return this.suggest((SuggestRequest)((Object)((SuggestRequest.Builder)SuggestRequest.builder().applyMutation(suggestRequest)).build()));
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(Consumer<UploadDocumentsRequest.Builder> uploadDocumentsRequest, AsyncRequestBody requestBody) {
        return this.uploadDocuments((UploadDocumentsRequest)((Object)((UploadDocumentsRequest.Builder)UploadDocumentsRequest.builder().applyMutation(uploadDocumentsRequest)).build()), requestBody);
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, Path sourcePath) {
        return this.uploadDocuments(uploadDocumentsRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(Consumer<UploadDocumentsRequest.Builder> uploadDocumentsRequest, Path sourcePath) {
        return this.uploadDocuments((UploadDocumentsRequest)((Object)((UploadDocumentsRequest.Builder)UploadDocumentsRequest.builder().applyMutation(uploadDocumentsRequest)).build()), sourcePath);
    }
}

