/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hit;
import software.amazon.awssdk.services.cloudsearchdomain.model.HitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hits> {
    private static final SdkField<Long> FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("found").getter(Hits.getter(Hits::found)).setter(Hits.setter(Builder::found)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("found").build()}).build();
    private static final SdkField<Long> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("start").getter(Hits.getter(Hits::start)).setter(Hits.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<String> CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cursor").getter(Hits.getter(Hits::cursor)).setter(Hits.setter(Builder::cursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cursor").build()}).build();
    private static final SdkField<List<Hit>> HIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hit").getter(Hits.getter(Hits::hit)).setter(Hits.setter(Builder::hit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hit").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Hit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOUND_FIELD, START_FIELD, CURSOR_FIELD, HIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long found;
    private final Long start;
    private final String cursor;
    private final List<Hit> hit;

    private Hits(BuilderImpl builder) {
        this.found = builder.found;
        this.start = builder.start;
        this.cursor = builder.cursor;
        this.hit = builder.hit;
    }

    public final Long found() {
        return this.found;
    }

    public final Long start() {
        return this.start;
    }

    public final String cursor() {
        return this.cursor;
    }

    public final boolean hasHit() {
        return this.hit != null && !(this.hit instanceof SdkAutoConstructList);
    }

    public final List<Hit> hit() {
        return this.hit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.found());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.cursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHit() ? this.hit() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hits)) {
            return false;
        }
        Hits other = (Hits)obj;
        return Objects.equals(this.found(), other.found()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.cursor(), other.cursor()) && this.hasHit() == other.hasHit() && Objects.equals(this.hit(), other.hit());
    }

    public final String toString() {
        return ToString.builder((String)"Hits").add("Found", (Object)this.found()).add("Start", (Object)this.start()).add("Cursor", (Object)this.cursor()).add("Hit", this.hasHit() ? this.hit() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "found": {
                return Optional.ofNullable(clazz.cast(this.found()));
            }
            case "start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "cursor": {
                return Optional.ofNullable(clazz.cast(this.cursor()));
            }
            case "hit": {
                return Optional.ofNullable(clazz.cast(this.hit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hits, T> g) {
        return obj -> g.apply((Hits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long found;
        private Long start;
        private String cursor;
        private List<Hit> hit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hits model) {
            this.found(model.found);
            this.start(model.start);
            this.cursor(model.cursor);
            this.hit(model.hit);
        }

        public final Long getFound() {
            return this.found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final Long getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final String getCursor() {
            return this.cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public final Collection<Hit.Builder> getHit() {
            if (this.hit instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hit != null ? (Collection)this.hit.stream().map(Hit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Hit ... hit) {
            this.hit(Arrays.asList(hit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Consumer<Hit.Builder> ... hit) {
            this.hit(Stream.of(hit).map(c -> (Hit)((Hit.Builder)Hit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHit(Collection<Hit.BuilderImpl> hit) {
            this.hit = HitListCopier.copyFromBuilder(hit);
        }

        public Hits build() {
            return new Hits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hits> {
        public Builder found(Long var1);

        public Builder start(Long var1);

        public Builder cursor(String var1);

        public Builder hit(Collection<Hit> var1);

        public Builder hit(Hit ... var1);

        public Builder hit(Consumer<Hit.Builder> ... var1);
    }
}

