/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.DomainNameMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainNamesResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, ListDomainNamesResponse> {
    private static final SdkField<Map<String, String>> DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ListDomainNamesResponse.getter(ListDomainNamesResponse::domainNames)).setter(ListDomainNamesResponse.setter(Builder::domainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAMES_FIELD));
    private final Map<String, String> domainNames;

    private ListDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    public Map<String, String> domainNames() {
        return this.domainNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse)((Object)obj);
        return Objects.equals(this.domainNames(), other.domainNames());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainNamesResponse").add("DomainNames", this.domainNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainNamesResponse, T> g) {
        return obj -> g.apply((ListDomainNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private Map<String, String> domainNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            super(model);
            this.domainNames(model.domainNames);
        }

        public final Map<String, String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final Builder domainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
            return this;
        }

        public final void setDomainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
        }

        @Override
        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainNamesResponse> {
        public Builder domainNames(Map<String, String> var1);
    }
}

