/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeStatus;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefineAnalysisSchemeResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DefineAnalysisSchemeResponse> {
    private static final SdkField<AnalysisSchemeStatus> ANALYSIS_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalysisScheme").getter(DefineAnalysisSchemeResponse.getter(DefineAnalysisSchemeResponse::analysisScheme)).setter(DefineAnalysisSchemeResponse.setter(Builder::analysisScheme)).constructor(AnalysisSchemeStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisScheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefineAnalysisSchemeResponse.memberNameToFieldInitializer();
    private final AnalysisSchemeStatus analysisScheme;

    private DefineAnalysisSchemeResponse(BuilderImpl builder) {
        super(builder);
        this.analysisScheme = builder.analysisScheme;
    }

    public final AnalysisSchemeStatus analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisScheme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineAnalysisSchemeResponse)) {
            return false;
        }
        DefineAnalysisSchemeResponse other = (DefineAnalysisSchemeResponse)((Object)obj);
        return Objects.equals(this.analysisScheme(), other.analysisScheme());
    }

    public final String toString() {
        return ToString.builder((String)"DefineAnalysisSchemeResponse").add("AnalysisScheme", (Object)this.analysisScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisScheme": {
                return Optional.ofNullable(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AnalysisSchemeStatus>> map = new HashMap<String, SdkField<AnalysisSchemeStatus>>();
        map.put("AnalysisScheme", ANALYSIS_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefineAnalysisSchemeResponse, T> g) {
        return obj -> g.apply((DefineAnalysisSchemeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private AnalysisSchemeStatus analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineAnalysisSchemeResponse model) {
            super(model);
            this.analysisScheme(model.analysisScheme);
        }

        public final AnalysisSchemeStatus.Builder getAnalysisScheme() {
            return this.analysisScheme != null ? this.analysisScheme.toBuilder() : null;
        }

        public final void setAnalysisScheme(AnalysisSchemeStatus.BuilderImpl analysisScheme) {
            this.analysisScheme = analysisScheme != null ? analysisScheme.build() : null;
        }

        @Override
        public final Builder analysisScheme(AnalysisSchemeStatus analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        @Override
        public DefineAnalysisSchemeResponse build() {
            return new DefineAnalysisSchemeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DefineAnalysisSchemeResponse> {
        public Builder analysisScheme(AnalysisSchemeStatus var1);

        default public Builder analysisScheme(Consumer<AnalysisSchemeStatus.Builder> analysisScheme) {
            return this.analysisScheme((AnalysisSchemeStatus)((AnalysisSchemeStatus.Builder)AnalysisSchemeStatus.builder().applyMutation(analysisScheme)).build());
        }
    }
}

