/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.Suggester;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefineSuggesterRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DefineSuggesterRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DefineSuggesterRequest.getter(DefineSuggesterRequest::domainName)).setter(DefineSuggesterRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Suggester> SUGGESTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Suggester").getter(DefineSuggesterRequest.getter(DefineSuggesterRequest::suggester)).setter(DefineSuggesterRequest.setter(Builder::suggester)).constructor(Suggester::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggester").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SUGGESTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefineSuggesterRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final Suggester suggester;

    private DefineSuggesterRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggester = builder.suggester;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Suggester suggester() {
        return this.suggester;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggester());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineSuggesterRequest)) {
            return false;
        }
        DefineSuggesterRequest other = (DefineSuggesterRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.suggester(), other.suggester());
    }

    public final String toString() {
        return ToString.builder((String)"DefineSuggesterRequest").add("DomainName", (Object)this.domainName()).add("Suggester", (Object)this.suggester()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Suggester": {
                return Optional.ofNullable(clazz.cast(this.suggester()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Suggester", SUGGESTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefineSuggesterRequest, T> g) {
        return obj -> g.apply((DefineSuggesterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Suggester suggester;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineSuggesterRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.suggester(model.suggester);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Suggester.Builder getSuggester() {
            return this.suggester != null ? this.suggester.toBuilder() : null;
        }

        public final void setSuggester(Suggester.BuilderImpl suggester) {
            this.suggester = suggester != null ? suggester.build() : null;
        }

        @Override
        public final Builder suggester(Suggester suggester) {
            this.suggester = suggester;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DefineSuggesterRequest build() {
            return new DefineSuggesterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DefineSuggesterRequest> {
        public Builder domainName(String var1);

        public Builder suggester(Suggester var1);

        default public Builder suggester(Consumer<Suggester.Builder> suggester) {
            return this.suggester((Suggester)((Suggester.Builder)Suggester.builder().applyMutation(suggester)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

