/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClientBuilder;
import software.amazon.awssdk.services.cloudsearch.CloudSearchServiceClientConfiguration;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchBaseClientBuilder;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.endpoints.CloudSearchEndpointProvider;

@SdkInternalApi
final class DefaultCloudSearchClientBuilder
extends DefaultCloudSearchBaseClientBuilder<CloudSearchClientBuilder, CloudSearchClient>
implements CloudSearchClientBuilder {
    DefaultCloudSearchClientBuilder() {
    }

    @Override
    public DefaultCloudSearchClientBuilder endpointProvider(CloudSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudSearchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudSearchClientBuilder.validateClientOptions(clientConfiguration);
        CloudSearchServiceClientConfiguration serviceClientConfiguration = CloudSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCloudSearchClient(serviceClientConfiguration, clientConfiguration);
    }
}

