/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.DocumentSuggesterOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Suggester
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Suggester> {
    private static final SdkField<String> SUGGESTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuggesterName").getter(Suggester.getter(Suggester::suggesterName)).setter(Suggester.setter(Builder::suggesterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggesterName").build()}).build();
    private static final SdkField<DocumentSuggesterOptions> DOCUMENT_SUGGESTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentSuggesterOptions").getter(Suggester.getter(Suggester::documentSuggesterOptions)).setter(Suggester.setter(Builder::documentSuggesterOptions)).constructor(DocumentSuggesterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSuggesterOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTER_NAME_FIELD, DOCUMENT_SUGGESTER_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String suggesterName;
    private final DocumentSuggesterOptions documentSuggesterOptions;

    private Suggester(BuilderImpl builder) {
        this.suggesterName = builder.suggesterName;
        this.documentSuggesterOptions = builder.documentSuggesterOptions;
    }

    public final String suggesterName() {
        return this.suggesterName;
    }

    public final DocumentSuggesterOptions documentSuggesterOptions() {
        return this.documentSuggesterOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suggesterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSuggesterOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suggester)) {
            return false;
        }
        Suggester other = (Suggester)obj;
        return Objects.equals(this.suggesterName(), other.suggesterName()) && Objects.equals(this.documentSuggesterOptions(), other.documentSuggesterOptions());
    }

    public final String toString() {
        return ToString.builder((String)"Suggester").add("SuggesterName", (Object)this.suggesterName()).add("DocumentSuggesterOptions", (Object)this.documentSuggesterOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggesterName": {
                return Optional.ofNullable(clazz.cast(this.suggesterName()));
            }
            case "DocumentSuggesterOptions": {
                return Optional.ofNullable(clazz.cast(this.documentSuggesterOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Suggester, T> g) {
        return obj -> g.apply((Suggester)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suggesterName;
        private DocumentSuggesterOptions documentSuggesterOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Suggester model) {
            this.suggesterName(model.suggesterName);
            this.documentSuggesterOptions(model.documentSuggesterOptions);
        }

        public final String getSuggesterName() {
            return this.suggesterName;
        }

        public final void setSuggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
        }

        @Override
        public final Builder suggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
            return this;
        }

        public final DocumentSuggesterOptions.Builder getDocumentSuggesterOptions() {
            return this.documentSuggesterOptions != null ? this.documentSuggesterOptions.toBuilder() : null;
        }

        public final void setDocumentSuggesterOptions(DocumentSuggesterOptions.BuilderImpl documentSuggesterOptions) {
            this.documentSuggesterOptions = documentSuggesterOptions != null ? documentSuggesterOptions.build() : null;
        }

        @Override
        public final Builder documentSuggesterOptions(DocumentSuggesterOptions documentSuggesterOptions) {
            this.documentSuggesterOptions = documentSuggesterOptions;
            return this;
        }

        public Suggester build() {
            return new Suggester(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Suggester> {
        public Builder suggesterName(String var1);

        public Builder documentSuggesterOptions(DocumentSuggesterOptions var1);

        default public Builder documentSuggesterOptions(Consumer<DocumentSuggesterOptions.Builder> documentSuggesterOptions) {
            return this.documentSuggesterOptions((DocumentSuggesterOptions)((DocumentSuggesterOptions.Builder)DocumentSuggesterOptions.builder().applyMutation(documentSuggesterOptions)).build());
        }
    }
}

