/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.DynamicFieldNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexFieldsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeIndexFieldsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::domainName)).setter(DescribeIndexFieldsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldNames").getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::fieldNames)).setter(DescribeIndexFieldsRequest.setter(Builder::fieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Deployed").getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::deployed)).setter(DescribeIndexFieldsRequest.setter(Builder::deployed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, FIELD_NAMES_FIELD, DEPLOYED_FIELD));
    private final String domainName;
    private final List<String> fieldNames;
    private final Boolean deployed;

    private DescribeIndexFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fieldNames = builder.fieldNames;
        this.deployed = builder.deployed;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasFieldNames() {
        return this.fieldNames != null && !(this.fieldNames instanceof SdkAutoConstructList);
    }

    public final List<String> fieldNames() {
        return this.fieldNames;
    }

    public final Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldNames() ? this.fieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsRequest)) {
            return false;
        }
        DescribeIndexFieldsRequest other = (DescribeIndexFieldsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasFieldNames() == other.hasFieldNames() && Objects.equals(this.fieldNames(), other.fieldNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIndexFieldsRequest").add("DomainName", (Object)this.domainName()).add("FieldNames", this.hasFieldNames() ? this.fieldNames() : null).add("Deployed", (Object)this.deployed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "FieldNames": {
                return Optional.ofNullable(clazz.cast(this.fieldNames()));
            }
            case "Deployed": {
                return Optional.ofNullable(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexFieldsRequest, T> g) {
        return obj -> g.apply((DescribeIndexFieldsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.fieldNames(model.fieldNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getFieldNames() {
            if (this.fieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fieldNames;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
        }

        @Override
        @Transient
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            this.fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        @Transient
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIndexFieldsRequest build() {
            return new DescribeIndexFieldsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexFieldsRequest> {
        public Builder domainName(String var1);

        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

