/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlgorithmicStemming {
    NONE("none"),
    MINIMAL("minimal"),
    LIGHT("light"),
    FULL("full"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlgorithmicStemming> VALUE_MAP;
    private final String value;

    private AlgorithmicStemming(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlgorithmicStemming fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlgorithmicStemming> knownValues() {
        EnumSet<AlgorithmicStemming> knownValues = EnumSet.allOf(AlgorithmicStemming.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlgorithmicStemming.class, AlgorithmicStemming::toString);
    }
}

