/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.DynamicFieldNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexFieldsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeIndexFieldsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::domainName)).setter(DescribeIndexFieldsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::fieldNames)).setter(DescribeIndexFieldsRequest.setter(Builder::fieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeIndexFieldsRequest.getter(DescribeIndexFieldsRequest::deployed)).setter(DescribeIndexFieldsRequest.setter(Builder::deployed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, FIELD_NAMES_FIELD, DEPLOYED_FIELD));
    private final String domainName;
    private final List<String> fieldNames;
    private final Boolean deployed;

    private DescribeIndexFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fieldNames = builder.fieldNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsRequest)) {
            return false;
        }
        DescribeIndexFieldsRequest other = (DescribeIndexFieldsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.fieldNames(), other.fieldNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIndexFieldsRequest").add("DomainName", (Object)this.domainName()).add("FieldNames", this.fieldNames()).add("Deployed", (Object)this.deployed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "FieldNames": {
                return Optional.ofNullable(clazz.cast(this.fieldNames()));
            }
            case "Deployed": {
                return Optional.ofNullable(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexFieldsRequest, T> g) {
        return obj -> g.apply((DescribeIndexFieldsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.fieldNames(model.fieldNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            this.fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIndexFieldsRequest build() {
            return new DescribeIndexFieldsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexFieldsRequest> {
        public Builder domainName(String var1);

        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

