/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.FieldNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexDocumentsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, IndexDocumentsResponse> {
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(IndexDocumentsResponse.getter(IndexDocumentsResponse::fieldNames)).setter(IndexDocumentsResponse.setter(Builder::fieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAMES_FIELD));
    private final List<String> fieldNames;

    private IndexDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.fieldNames = builder.fieldNames;
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexDocumentsResponse)) {
            return false;
        }
        IndexDocumentsResponse other = (IndexDocumentsResponse)((Object)obj);
        return Objects.equals(this.fieldNames(), other.fieldNames());
    }

    public String toString() {
        return ToString.builder((String)"IndexDocumentsResponse").add("FieldNames", this.fieldNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldNames": {
                return Optional.ofNullable(clazz.cast(this.fieldNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexDocumentsResponse, T> g) {
        return obj -> g.apply((IndexDocumentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexDocumentsResponse model) {
            super(model);
            this.fieldNames(model.fieldNames);
        }

        public final Collection<String> getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            this.fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
        }

        @Override
        public IndexDocumentsResponse build() {
            return new IndexDocumentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IndexDocumentsResponse> {
        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);
    }
}

