/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeDomainsResponse> {
    private static final SdkField<List<DomainStatus>> DOMAIN_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDomainsResponse.getter(DescribeDomainsResponse::domainStatusList)).setter(DescribeDomainsResponse.setter(Builder::domainStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_LIST_FIELD));
    private final List<DomainStatus> domainStatusList;

    private DescribeDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    public List<DomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainsResponse)) {
            return false;
        }
        DescribeDomainsResponse other = (DescribeDomainsResponse)((Object)obj);
        return Objects.equals(this.domainStatusList(), other.domainStatusList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainsResponse").add("DomainStatusList", this.domainStatusList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.ofNullable(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainsResponse, T> g) {
        return obj -> g.apply((DescribeDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<DomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainsResponse model) {
            super(model);
            this.domainStatusList(model.domainStatusList);
        }

        public final Collection<DomainStatus.Builder> getDomainStatusList() {
            return this.domainStatusList != null ? (Collection)this.domainStatusList.stream().map(DomainStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<DomainStatus> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(DomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<DomainStatus.Builder> ... domainStatusList) {
            this.domainStatusList(Stream.of(domainStatusList).map(c -> (DomainStatus)((DomainStatus.Builder)DomainStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainStatusList(Collection<DomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public DescribeDomainsResponse build() {
            return new DescribeDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainsResponse> {
        public Builder domainStatusList(Collection<DomainStatus> var1);

        public Builder domainStatusList(DomainStatus ... var1);

        public Builder domainStatusList(Consumer<DomainStatus.Builder> ... var1);
    }
}

