/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.AlgorithmicStemming;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisOptions> {
    private static final SdkField<String> SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisOptions.getter(AnalysisOptions::synonyms)).setter(AnalysisOptions.setter(Builder::synonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Synonyms").build()}).build();
    private static final SdkField<String> STOPWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisOptions.getter(AnalysisOptions::stopwords)).setter(AnalysisOptions.setter(Builder::stopwords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stopwords").build()}).build();
    private static final SdkField<String> STEMMING_DICTIONARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisOptions.getter(AnalysisOptions::stemmingDictionary)).setter(AnalysisOptions.setter(Builder::stemmingDictionary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StemmingDictionary").build()}).build();
    private static final SdkField<String> JAPANESE_TOKENIZATION_DICTIONARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisOptions.getter(AnalysisOptions::japaneseTokenizationDictionary)).setter(AnalysisOptions.setter(Builder::japaneseTokenizationDictionary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JapaneseTokenizationDictionary").build()}).build();
    private static final SdkField<String> ALGORITHMIC_STEMMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisOptions.getter(AnalysisOptions::algorithmicStemmingAsString)).setter(AnalysisOptions.setter(Builder::algorithmicStemming)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmicStemming").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNONYMS_FIELD, STOPWORDS_FIELD, STEMMING_DICTIONARY_FIELD, JAPANESE_TOKENIZATION_DICTIONARY_FIELD, ALGORITHMIC_STEMMING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String synonyms;
    private final String stopwords;
    private final String stemmingDictionary;
    private final String japaneseTokenizationDictionary;
    private final String algorithmicStemming;

    private AnalysisOptions(BuilderImpl builder) {
        this.synonyms = builder.synonyms;
        this.stopwords = builder.stopwords;
        this.stemmingDictionary = builder.stemmingDictionary;
        this.japaneseTokenizationDictionary = builder.japaneseTokenizationDictionary;
        this.algorithmicStemming = builder.algorithmicStemming;
    }

    public String synonyms() {
        return this.synonyms;
    }

    public String stopwords() {
        return this.stopwords;
    }

    public String stemmingDictionary() {
        return this.stemmingDictionary;
    }

    public String japaneseTokenizationDictionary() {
        return this.japaneseTokenizationDictionary;
    }

    public AlgorithmicStemming algorithmicStemming() {
        return AlgorithmicStemming.fromValue(this.algorithmicStemming);
    }

    public String algorithmicStemmingAsString() {
        return this.algorithmicStemming;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.synonyms());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopwords());
        hashCode = 31 * hashCode + Objects.hashCode(this.stemmingDictionary());
        hashCode = 31 * hashCode + Objects.hashCode(this.japaneseTokenizationDictionary());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmicStemmingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisOptions)) {
            return false;
        }
        AnalysisOptions other = (AnalysisOptions)obj;
        return Objects.equals(this.synonyms(), other.synonyms()) && Objects.equals(this.stopwords(), other.stopwords()) && Objects.equals(this.stemmingDictionary(), other.stemmingDictionary()) && Objects.equals(this.japaneseTokenizationDictionary(), other.japaneseTokenizationDictionary()) && Objects.equals(this.algorithmicStemmingAsString(), other.algorithmicStemmingAsString());
    }

    public String toString() {
        return ToString.builder((String)"AnalysisOptions").add("Synonyms", (Object)this.synonyms()).add("Stopwords", (Object)this.stopwords()).add("StemmingDictionary", (Object)this.stemmingDictionary()).add("JapaneseTokenizationDictionary", (Object)this.japaneseTokenizationDictionary()).add("AlgorithmicStemming", (Object)this.algorithmicStemmingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Synonyms": {
                return Optional.ofNullable(clazz.cast(this.synonyms()));
            }
            case "Stopwords": {
                return Optional.ofNullable(clazz.cast(this.stopwords()));
            }
            case "StemmingDictionary": {
                return Optional.ofNullable(clazz.cast(this.stemmingDictionary()));
            }
            case "JapaneseTokenizationDictionary": {
                return Optional.ofNullable(clazz.cast(this.japaneseTokenizationDictionary()));
            }
            case "AlgorithmicStemming": {
                return Optional.ofNullable(clazz.cast(this.algorithmicStemmingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisOptions, T> g) {
        return obj -> g.apply((AnalysisOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String synonyms;
        private String stopwords;
        private String stemmingDictionary;
        private String japaneseTokenizationDictionary;
        private String algorithmicStemming;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisOptions model) {
            this.synonyms(model.synonyms);
            this.stopwords(model.stopwords);
            this.stemmingDictionary(model.stemmingDictionary);
            this.japaneseTokenizationDictionary(model.japaneseTokenizationDictionary);
            this.algorithmicStemming(model.algorithmicStemming);
        }

        public final String getSynonyms() {
            return this.synonyms;
        }

        @Override
        public final Builder synonyms(String synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public final void setSynonyms(String synonyms) {
            this.synonyms = synonyms;
        }

        public final String getStopwords() {
            return this.stopwords;
        }

        @Override
        public final Builder stopwords(String stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public final void setStopwords(String stopwords) {
            this.stopwords = stopwords;
        }

        public final String getStemmingDictionary() {
            return this.stemmingDictionary;
        }

        @Override
        public final Builder stemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
            return this;
        }

        public final void setStemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
        }

        public final String getJapaneseTokenizationDictionary() {
            return this.japaneseTokenizationDictionary;
        }

        @Override
        public final Builder japaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
            return this;
        }

        public final void setJapaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
        }

        public final String getAlgorithmicStemming() {
            return this.algorithmicStemming;
        }

        @Override
        public final Builder algorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
            return this;
        }

        @Override
        public final Builder algorithmicStemming(AlgorithmicStemming algorithmicStemming) {
            this.algorithmicStemming(algorithmicStemming.toString());
            return this;
        }

        public final void setAlgorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
        }

        public AnalysisOptions build() {
            return new AnalysisOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisOptions> {
        public Builder synonyms(String var1);

        public Builder stopwords(String var1);

        public Builder stemmingDictionary(String var1);

        public Builder japaneseTokenizationDictionary(String var1);

        public Builder algorithmicStemming(String var1);

        public Builder algorithmicStemming(AlgorithmicStemming var1);
    }
}

