/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.FacetsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hits;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus;
import software.amazon.awssdk.services.cloudsearchdomain.model.StatsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, SearchResponse> {
    private final SearchStatus status;
    private final Hits hits;
    private final Map<String, BucketInfo> facets;
    private final Map<String, FieldStats> stats;

    private SearchResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.hits = builder.hits;
        this.facets = builder.facets;
        this.stats = builder.stats;
    }

    public SearchStatus status() {
        return this.status;
    }

    public Hits hits() {
        return this.hits;
    }

    public Map<String, BucketInfo> facets() {
        return this.facets;
    }

    public Map<String, FieldStats> stats() {
        return this.stats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hits());
        hashCode = 31 * hashCode + Objects.hashCode(this.facets());
        hashCode = 31 * hashCode + Objects.hashCode(this.stats());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.hits(), other.hits()) && Objects.equals(this.facets(), other.facets()) && Objects.equals(this.stats(), other.stats());
    }

    public String toString() {
        return ToString.builder((String)"SearchResponse").add("Status", (Object)this.status()).add("Hits", (Object)this.hits()).add("Facets", this.facets()).add("Stats", this.stats()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "hits": {
                return Optional.of(clazz.cast(this.hits()));
            }
            case "facets": {
                return Optional.of(clazz.cast(this.facets()));
            }
            case "stats": {
                return Optional.of(clazz.cast(this.stats()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private SearchStatus status;
        private Hits hits;
        private Map<String, BucketInfo> facets;
        private Map<String, FieldStats> stats;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResponse model) {
            this.status(model.status);
            this.hits(model.hits);
            this.facets(model.facets);
            this.stats(model.stats);
        }

        public final SearchStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Hits.Builder getHits() {
            return this.hits != null ? this.hits.toBuilder() : null;
        }

        @Override
        public final Builder hits(Hits hits) {
            this.hits = hits;
            return this;
        }

        public final void setHits(Hits.BuilderImpl hits) {
            this.hits = hits != null ? hits.build() : null;
        }

        public final Map<String, BucketInfo.Builder> getFacets() {
            return this.facets != null ? CollectionUtils.mapValues(this.facets, BucketInfo::toBuilder) : null;
        }

        @Override
        public final Builder facets(Map<String, BucketInfo> facets) {
            this.facets = FacetsCopier.copy(facets);
            return this;
        }

        public final void setFacets(Map<String, BucketInfo.BuilderImpl> facets) {
            this.facets = FacetsCopier.copyFromBuilder(facets);
        }

        public final Map<String, FieldStats.Builder> getStats() {
            return this.stats != null ? CollectionUtils.mapValues(this.stats, FieldStats::toBuilder) : null;
        }

        @Override
        public final Builder stats(Map<String, FieldStats> stats) {
            this.stats = StatsCopier.copy(stats);
            return this;
        }

        public final void setStats(Map<String, FieldStats.BuilderImpl> stats) {
            this.stats = StatsCopier.copyFromBuilder(stats);
        }

        @Override
        public SearchResponse build() {
            return new SearchResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    CopyableBuilder<Builder, SearchResponse> {
        public Builder status(SearchStatus var1);

        default public Builder status(Consumer<SearchStatus.Builder> status) {
            return this.status((SearchStatus)((SearchStatus.Builder)SearchStatus.builder().apply(status)).build());
        }

        public Builder hits(Hits var1);

        default public Builder hits(Consumer<Hits.Builder> hits) {
            return this.hits((Hits)((Hits.Builder)Hits.builder().apply(hits)).build());
        }

        public Builder facets(Map<String, BucketInfo> var1);

        public Builder stats(Map<String, FieldStats> var1);
    }
}

